/*--------------------------------------------------------------------------------

	SXPath.h

	Copyright (c) 2002, Raritan Computer, Inc.

	Header file for CSXPath.cpp.
	Contains CSXPath class definition.

--------------------------------------------------------------------------------*/

#ifndef _SXPATH_H_
#define	_SXPATH_H_

#include "pp/SXML_Errors.h"

// forward declaration
class   CSXDB_Node;
class   CSXDB;


//----------------------------------------
//				Equates
//----------------------------------------

#define	SXP_NODES_PER_LIST			32	// # of nodes per node list
#define	SXP_MAX_STRING				128	// Max size of any string

//----------------------------------------
//				Data Types
//----------------------------------------

	// Node list

typedef struct CSX_NODE_LIST
{
	struct CSX_NODE_LIST * pNext;
	CSXDB_Node	*	pNodes[SXP_NODES_PER_LIST];
} CSX_NODE_LIST;

	// Node search recursive info

typedef struct
{
	CSXDB	*	pDB;					// The database being searched
	void	*	pUser;					// User account being used
} NODE_PARSE_INFO;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				CSXPath Class
//----------------------------------------

class CSXPath
{
public:

	CSXPath
	(
	);

	virtual
	~CSXPath
	(
	);

	int									// returns error code or # of nodes found
	Parse
	(
		const char		*	pXPath,			// Ptr to the XPath string
		CSXDB		*	pDB,			// Ptr to the database to search
		CSXDB_Node	*	pContextNode = NULL,	// The current context node
										// Set to NULL to use root as the context node
		int				maxNodes = 0,	// maxNodes to parse (0 - no limit)
		void		*	pUser = NULL	// User account
	);

	CSXDB_Node	*						// The node or NULL if index is out of range
	Enum
	(
		int			index				// Which node to return
	);

//	inline
	int
	GetTokenPosition
	(
	);

private:

	int									// returns error code or # of nodes found
	ParseNode
	(
		CSXDB_Node	*	pContextNode,
		NODE_PARSE_INFO * pInfo
	);

	int									// Token type parsed
	Lex
	(
	);

	int									// Token type parsed
	AddNode
	(
		CSXDB_Node	*pNode				// The node to add
	);

	void
	DeleteAllNodes
	(
	);

	CSXDB_Node *						// the found node or NULL
	Find
	(
		CSXDB		*	pDB,			// The data base
		int				type,			// SXDB_TYPE_
		const char	*	pName,			// Name of the attribute
		const char	*	pData			// ID to find
	);

	int									// Token type parsed
	FindRecursive
	(
		CSXDB_Node	*	pNode,			// The data base
		int				type,			// SXDB_TYPE_
		const char	*	pName,			// Name of the attribute
		const char	*	pData			// ID to find
	);

	const char	*pXPathStart;				// Ptr to the start of the xpath data
	const char	*pXPath;					// Ptr to the next data to parse
	int		tokenPosition;				// character offset to current token
	int		token;						// Last token parsed
	int		number;						// Numeric value of token
	int		isNumber;					// !0 if the string is all numeric (number = its value)
	char	string[SXP_MAX_STRING];		// Max string size

	int		processPredicate;			// !0 if we are processing a predicate

	CSXDB_Node		*	pIDNode;		// Node found by unique ID

	int					maxNodes;		// max # of nodes to find
	int					count;			// # of nodes in the list
	CSX_NODE_LIST		firstList;		// The first list of found nodes
};

#endif // _SXPATH_H_
