/*--------------------------------------------------------------------------------

	Timer.h

	Copyright (c) 2001, Scott Coleman!

--------------------------------------------------------------------------------*/

#ifndef _Timer_h_
#define	_Timer_h_

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//		Supporting Data Types
//----------------------------------------

class CTimer;

typedef void (*PTIMERPROC)( CTimer * pThis, void *, void * );

//----------------------------------------
//			CTRCONNECTION Class
//----------------------------------------

class CTimer
{

public:
	

	// Constructors

	CTimer();		// Creates a timer that is stopped

	// Deconstructor

	virtual ~CTimer();

	// Methods

	void SetCTimerProc( PTIMERPROC pProc, void * param1 = NULL, void * param2 = NULL );
	void SetCTimer( DWORD period = 0, BOOL oneShot = FALSE );
	void StopCTimer();
	void StartCTimer();
	BOOL IsTimerRunning();
	DWORD GetRemainingTime();

	virtual void TimerProc();

	// Public Data...defined for the caller

	DWORD		dWord;					// A DWORD or the user's use
	VOID	*	ptr;					// ptr for the user's use

	// Don't call this...it's private

	void CTimerProcess();

    inline DWORD GetTimeLeft() { return timeLeft; };
	// Private Data

private:

	BOOL		running;				// TRUE if this timer is running
	DWORD		timeLeft;				// Time left until we call the proc
	DWORD		reload;					// Reload time
	PTIMERPROC	pProc;					// Ptr to the proc to call
	CTimer	*	pNext;					// ptr to the next timer

	void	*	p1;						// Passed to the trigger proc
	void	*	p2;						// Passed to the trigger proc

	// private functions

	void InitTimer();
	
};

#endif
