/*--------------------------------------------------------------------------------

	RandomData.c

	Copyright (c) 2000, Raritan Computer, Inc.

	Misc. utility functions

--------------------------------------------------------------------------------*/

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Functions
//----------------------------------------
#ifdef __cplusplus
extern "C"
{
#endif

#include	<time.h>
#include    <stdlib.h>
#include	<pp/OS_Port.h>
#include	<pp/RandomData.h>

//--------------------------------------------------------------------------------
//
	void
	GetRandomData
	(
		void		*	pData,
		DWORD			count
	)
//
//	Returns a string of random data.
//
//--------------------------------------------------------------------------------
{
	DWORD		seed;
	static DWORD lastSeed;				// Yes, I know I am not initializing this value...makes it more random
	BYTE	*	p = (BYTE *) pData;
	BYTE		xOr;
	time_t		now;
	struct tm	*t;

	now = time( (time_t *)NULL );
	t = localtime( &now );

	seed = OS_GetTickCount();

	seed = seed ^ lastSeed;

	seed = seed ^ ( (((DWORD) t->tm_wday) << 24) | (((DWORD) t->tm_min) << 16) | (((DWORD) t->tm_mday) << 8) | t->tm_hour );

	xOr = (BYTE) ((t->tm_sec * t->tm_min) ^ t->tm_sec ^ t->tm_wday ^ t->tm_mday ^ t->tm_hour ^ t->tm_mon);

	srand( seed );

	while (count--)
	{
		*p++ += (BYTE) (( ((rand() + seed) >> 3) & 0xFF) ^ xOr);
		xOr += (BYTE) rand();
		if (xOr & 0x01)
			xOr += 4 + (BYTE) OS_GetTickCount();
	}

	lastSeed = seed;
}

#ifdef __cplusplus
}
#endif
