/*--------------------------------------------------------------------------------

	CmdLineParse.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for CmdLineParse.cpp

--------------------------------------------------------------------------------*/

#ifndef _PP_CMDLINEPARSE_H
#define	_PP_CMDLINEPARSE_H

//----------------------------------------
//				Equates
//----------------------------------------

#define	TOKENNOTFOUND	-1

//----------------------------------------
//				Data Types
//----------------------------------------

typedef struct {
    const char * name;	// Name of the token
    int	value;		// the value of the token
} TOKEN;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

const char *					// Returns the ptr to the the to character in the string after the white space
SkipDelimiters(const char * string,		// String that contains the token
	       const char * delimiters = NULL);	// NULL for default delimiters or ptr to delimiter string

const char *					// Returns the ptr to the the to character in the string after the token
GetNextValue(const char * string,		// String that contains the token
	     int * value,			// where the value is stored
	     int * bFound = NULL,		// returns true if a number was found
	     const char * delimiters = NULL);	// NULL for default delimiters or ptr to delimiter string

const char *								// Returns the ptr to the the to character in the string after the token
GetNextToken(const char * string,		// String that contains the token
	     char * buffer,			// where the token is stored
	     int bufferSize,			// size of the buffer
	     int caseMode =1,			// -1 = lower case, 0 = no case conversion, 1 for upper case; (Defult is upper)
	     const char * delimiters = NULL);	// NULL for default delimiters or ptr to delimiter string

const char *					// Returns the ptr to the the to character in the string after the token
GetNextIPAddress(const char * string,		// String that contains the token
		 int * value,			// where the ip address value is stored
		 int * bFound);			// returns true if a number was found

int
GetTokenValue(const char * string,		// String that contains the token
	      TOKEN * tokenList);		// list of TOKEN structures

int						// number of tokens in the string
CountTokens(const char * string,		// String that contains the token
	    const char * delimiters);		// NULL for default delimiters or ptr to delimiter string

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Fucntions
//----------------------------------------


#endif // _PP_CMDLINEPARSE_H
