#include <sys/mman.h>
#include <pp/base.h>

void *
pp_mmap_malloc(size_t size)
{
    void *result;

    /* Some programs will call malloc (0).  Lets be strict and return NULL */
    if (size == 0) { return NULL; }

    result = mmap((void *) 0, size + sizeof(size_t), PROT_READ | PROT_WRITE,
		  MAP_PRIVATE | MAP_ANONYMOUS, 0, 0);

    if (result == MAP_FAILED) { return NULL; }
        
    *(size_t *)result = size;
    return (result + sizeof(size_t));
}

void
pp_mmap_free(void * ptr)
{
    if (ptr) {
	ptr -= sizeof(size_t);
	munmap(ptr, *(size_t *)ptr + sizeof(size_t));
    }
}

void *
pp_mmap_realloc(void * ptr, size_t size)
{
    void * newptr = NULL;

    if (size > 0) {
	newptr = pp_mmap_malloc(size);
	if (newptr && ptr) {
	    memcpy(newptr, ptr, * ((size_t *) (ptr - sizeof(size_t))));
	    pp_mmap_free(ptr);
	}
    } else {
	pp_mmap_free(ptr);
    }
    return newptr;
}
