/*
 * Internal header of balloc
 * I need to know the size of the ballocator structure within the
 * shared memory header, so I needed to extract these definitions
 *
 * (c) 2004 Peppercon
 * tbr@peppercon.de
 */

#ifndef _BALLOC_INTERN_H
#define _BALLOC_INTERN_H

#define PP_B_SHIFT	 4			/* Convert size to class */
#define PP_B_ROUND	 ((1 << (PP_B_SHIFT)) - 1)
#define PP_B_MAX_CLASS	 13			/* Maximum class number + 1 */
#define PP_B_MALLOCED	 0x80000000		/* Block was malloced */
#define PP_B_DEFAULT_MEM (64 * 1024)		/* Default memory allocation */
#define PP_B_MAX_FILES	 (512)			/* Maximum number of files */
#define PP_B_FILL_CHAR	 (0x77)			/* Fill byte for buffers */
#define PP_B_FILL_WORD	 (0x77777777)		/* Fill word for buffers */
#define PP_B_MAX_BLOCKS	 (64 * 1024)		/* Maximum allocated blocks */
#define FNAMESIZE 256


/*
 * Block classes are: 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 
 *		      16384, 32768, 65536 
 */
typedef struct {
    union {
	void	*next;	/* Pointer to next in q */
	size_t	size;	/* Actual requested size */
    } u;
    int	flags;		/* Per block allocation flags */
} bType;

/*
 * Define PP_B_STATS if you wish to track memory block and stack usage
 */
#ifdef PP_B_STATS

/*
 * Optional statistics
 */

typedef struct {
    long	alloc;			/* Block allocation calls */
    long	inuse;			/* Blocks in use */
} bStatsType;

typedef struct {
    char 	file[FNAMESIZE];
    long	allocated;		/* Bytes currently allocated */
    long	count;			/* Current block count */
    long	times;			/* Count of alloc attempts */
    long	largest;		/* largest allocated here */
    int		q;
} bStatsFileType;

/*
 * This one is very expensive but great stats
 */
typedef struct {
    void		*ptr;		/* Pointer to memory */
    bStatsFileType	*who;		/* Who allocated the memory */
} bStatsBlkType;

#endif /* PP_B_STATS */

typedef struct bmallocator_s {
    pp_mallocator_t base;

    bType* bQhead[PP_B_MAX_CLASS];	/* Per class block q head */
    char* bFreeBuf;		        /* Pointer to free memory */
    char* bFreeNext;		        /* Pointer to next free mem */
    int bFreeSize;		        /* Size of free memory */
    int bFreeLeft;		        /* Size of free left for use */
    int bFlags;	                        /* Default to auto-malloc */
    pthread_mutex_t mtx;
    
#ifdef PP_B_STATS
    bStatsType	bStats[PP_B_MAX_CLASS];	        /* Per class stats */
    bStatsFileType bStatsFiles[PP_B_MAX_FILES]; /* Per file stats */
    bStatsBlkType bStatsBlks[PP_B_MAX_BLOCKS];  /* Per block stats */
    int	bStatsBlksMax;	                        /* Max block entry */
    int	bStatsFilesMax;	                        /* Max file entry */
    int bStatsMemInUse;	                        /* Memory currently in use */
    int	bStatsBallocInUse;	                /* Memory currently balloced */
    int	bStatsMemMax;                           /* Max memory ever used */
    int	bStatsBallocMax;	                /* Max memory ever balloced */
    void *bStackMin;                            /* Miniumum stack position */
    void *bStackStart;		                /* Starting stack position */
    int bStatsMemMalloc;	                /* Malloced memory */
#endif /* PP_B_STATS */
    
} bmallocator_t;


void pp_binit(bmallocator_t* a, void* buf, size_t bufsize, int flags,
	      void  (*lock)(pp_mallocator_t* a),
	      void  (*unlock)(pp_mallocator_t* a),
	      void  (*mutex_init)(pp_mallocator_t* a, pp_mutex_t* m,
				  pp_mutex_kind_t k),
	      int is_proc_shared);

#endif /* _BALLOC_INTERN_H */
