#include <pp/base.h>

static const char base64enc[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
static const signed char base64dec[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,
    -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
    -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

void
pp_base64_enc(const char *in, size_t ins, char *out)
{
    u_int32_t temp;
    u_int i;
    for (i = 0; i < ins; i += 3) {
	if (ins - i > 2) {
	    temp = (unsigned char)in[i] << 16 | (unsigned char)in[i + 1] << 8 | (unsigned char)in[i + 2];
	    *out++ = base64enc[(temp >> 18) & 0x3f];
	    *out++ = base64enc[(temp >> 12) & 0x3f];
	    *out++ = base64enc[(temp >> 6)  & 0x3f];
	    *out++ = base64enc[temp         & 0x3f];
	} else if (ins - i == 2) {
	    temp = (unsigned char)in[i] << 16 | (unsigned char)in[i + 1] << 8;
	    *out++ = base64enc[(temp >> 18) & 0x3f];
	    *out++ = base64enc[(temp >> 12) & 0x3f];
	    *out++ = base64enc[(temp >> 6)  & 0x3f];
	    *out++ = '=';
	} else if (ins - i == 1) {
	    temp = (unsigned char)in[i] << 16;
	    *out++ = base64enc[(temp >> 18) & 0x3f];
	    *out++ = base64enc[(temp >> 12) & 0x3f];
	    *out++ = '=';
	    *out++ = '=';
	}
    }
    *out++=0;
}

int
pp_base64_dec(const char *in, size_t ins, char *out, size_t *outs)
{
    u_int32_t temp;
    u_int i;
    char *orig = out;
    if (ins % 4 > 0) return PP_ERR;
    for (i = 0; i < ins; i += 4) {
	if (in[i + 2] == '=') {
	    if (base64dec[(int)in[i]] == -1
		|| base64dec[(int)in[i + 1]] == -1) {
		return PP_ERR;
	    }
	    temp = (base64dec[(int)in[i]] << 18)
		+ (base64dec[(int)in[i + 1]] << 12);
	    *out++ = (char)(temp >> 16);
	} else if (in[i + 3] == '=') {
	    if (base64dec[(int)in[i]] == -1
		|| base64dec[(int)in[i + 1]] == -1
		|| base64dec[(int)in[i + 2]] == -1) {
		return PP_ERR;
	    }
	    temp = (base64dec[(int)in[i]] << 18)
		+ (base64dec[(int)in[i + 1]] << 12)
		+ (base64dec[(int)in[i + 2]] << 6);
	    *out++ = (char)(temp >> 16);
	    *out++ = (char)(temp >> 8);
	} else {
	    if (base64dec[(int)in[i]] == -1
		|| base64dec[(int)in[i + 1]] == -1
		|| base64dec[(int)in[i + 2]] == -1
		|| base64dec[(int)in[i + 3]] == -1) {
		return PP_ERR;
	    }
	    temp = (base64dec[(int)in[i]] << 18)
		+ (base64dec[(int)in[i + 1]] << 12)
		+ (base64dec[(int)in[i + 2]] << 6)
		+ (base64dec[(int)in[i + 3]]);
	    *out++ = (char)(temp >> 16);
	    *out++ = (char)(temp >> 8);
	    *out++ = (char)(temp);
	}
    }
    *outs = out - orig;
    return PP_SUC;
}

size_t
pp_base64_size(size_t insize)
{
    if (insize % 3) {
	return (insize / 3 + 1) * 4;
    } else {
	return insize / 3 * 4;
    }
}
