/*
 * These are renaming rules mapping a general dictionary interface
 * to a particular implementation!
 *
 * Currently available implemenations are:
 *  - red-black-trees
 * 
 * This file replaces the dictionary interface of the libdict
 * packaged with the original rb_tree sources. I didn't like 'em,
 * since there were too many funktion pointers, what we currently don't need!
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#ifndef __PP_DICT_H__
#define __PP_DICT_H__

#include <pp/rb_tree.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PP_DICT_IMPL_RED_BLACK_TREE

#ifdef PP_DICT_IMPL_RED_BLACK_TREE
# define __PP_DICT_IMPL_NAME pp_rb_tree
# define __PP_DITR_IMPL_NAME pp_rb_iter
# define PP_DITR_INITIALIZER(dict) PP_RB_ITER_INITIALIZER(dict)
#endif
    
#define __PP_DICT_IMPL_SYM_(type, sym) type ## _ ## sym
#define __PP_DICT_IMPL_SYM(type, sym) __PP_DICT_IMPL_SYM_(type, sym)
#define __PP_DICT_IMPL(sym) __PP_DICT_IMPL_SYM(__PP_DICT_IMPL_NAME, sym)
#define __PP_DITR_IMPL(sym) __PP_DICT_IMPL_SYM(__PP_DITR_IMPL_NAME, sym)

#define pp_dict_cmp_func    __PP_DICT_IMPL(cmp_func)
#define pp_dict_dup_func    __PP_DICT_IMPL(dup_func)
#define pp_dict_del_func    __PP_DICT_IMPL(del_func)
#define pp_dict_vis_func    __PP_DICT_IMPL(vis_func)

#define pp_dict_t           __PP_DICT_IMPL(t)

#define pp_dict_new_with_alloc     __PP_DICT_IMPL(new_with_alloc)
#define pp_dict_str_new_with_alloc __PP_DICT_IMPL(str_new_with_alloc)
#define pp_dict_new         __PP_DICT_IMPL(new)
#define pp_dict_str_new     __PP_DICT_IMPL(str_new)
#define pp_dict_destroy     __PP_DICT_IMPL(destroy)
#define pp_dict_insert      __PP_DICT_IMPL(insert)
#define pp_dict_search      __PP_DICT_IMPL(search)
#define pp_dict_csearch     __PP_DICT_IMPL(csearch)
#define pp_dict_remove      __PP_DICT_IMPL(remove)
#define pp_dict_empty       __PP_DICT_IMPL(empty )
#define pp_dict_walk        __PP_DICT_IMPL(walk)
#define pp_dict_count       __PP_DICT_IMPL(count)

#define pp_ditr_t           __PP_DITR_IMPL(t)

#define pp_ditr_new         __PP_DITR_IMPL(new)
#define pp_ditr_destroy     __PP_DITR_IMPL(destroy)
#define pp_ditr_valid       __PP_DITR_IMPL(valid)
#define pp_ditr_invalidate  __PP_DITR_IMPL(invalidate)
#define pp_ditr_next        __PP_DITR_IMPL(next)
#define pp_ditr_prev        __PP_DITR_IMPL(prev )
#define pp_ditr_nextn       __PP_DITR_IMPL(nextn)
#define pp_ditr_prevn       __PP_DITR_IMPL(prevn)
#define pp_ditr_first       __PP_DITR_IMPL(first)
#define pp_ditr_last        __PP_DITR_IMPL(last)
#define pp_ditr_search      __PP_DITR_IMPL(search)
#define pp_ditr_key         __PP_DITR_IMPL(key)
#define pp_ditr_key_const   __PP_DITR_IMPL(key_const)
#define pp_ditr_data        __PP_DITR_IMPL(data)

/* this seems not to be implemented, currently
#define    pp_ditr_set_data __PP_DITR_IMPL ## _set_data
#define    pp_ditr_remove __PP_DITR_IMPL ## _remove
*/
 
#ifdef __cplusplus
}
#endif

#endif /* !_DICT_H_ */
