#ifndef _PP_LOG_H
#define _PP_LOG_H

#include <pp/win32.h>

#ifndef _WIN32
# if !defined(PP_CYGWIN)
# if defined __cplusplus ? __GNUC_PREREQ (2, 6) : __GNUC_PREREQ (2, 4)
#   define ___F    __PRETTY_FUNCTION__
# else
#  if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#   define ___F    __func__
#  else
#  endif
# endif
# else
#   define ___F    ((__const char *) "Test")
# endif
#else
#define ___F __FUNCTION__
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
    LOG_NOT_SILENT,
    LOG_IS_SILENT
} log_silent_t;

#ifndef _WIN32
extern void pp_log(const char * format, ...) __attribute__ ((format (printf, 1, 2)));
extern void pp_log_err(const char * format, ...) __attribute__ ((format (printf, 1, 2)));
extern void pp_log_hex(char *packet, unsigned int size);
#else
#define pp_log printf
#endif

#ifdef __cplusplus
}
#endif

#endif /* _PP_LOG_H */
