/*
 * An abstract memory allocator.
 * Used to abstract the place where to allocate memory from
 * i.e. heap, buffer, shared memory, etc
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#ifndef __MALLOCATOR_H__
#define __MALLOCATOR_H__

#include <stdlib.h>
#include <pp/win32.h>

#ifndef _WIN32
#include <pp/mutex.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct pp_mallocator_s pp_mallocator_t;

struct pp_mallocator_s {
    void* (*alloc)(pp_mallocator_t* a, size_t s);
    void* (*realloc)(pp_mallocator_t* a, void* m, size_t s);
    void  (*free)(pp_mallocator_t* a, void* m);
    void  (*lock)(pp_mallocator_t* a);
    void  (*unlock)(pp_mallocator_t* a);
    void  (*destroy)(pp_mallocator_t* a);
#ifndef _WIN32
	void  (*mutex_init)(pp_mallocator_t* a, pp_mutex_t* m, pp_mutex_kind_t k);
#endif
    int is_proc_shared;
};

void* pp_malloc(pp_mallocator_t* a, size_t s);

void* pp_realloc(pp_mallocator_t* a, void* m, size_t s);

void  pp_free(pp_mallocator_t* a, void* m);

void  pp_mallocator_destroy(pp_mallocator_t* a);
  
#ifndef _WIN32
void  pp_mallocator_mutex_init(pp_mallocator_t* a, pp_mutex_t* m,
			       pp_mutex_kind_t k);
#endif

int pp_mallocator_is_proc_shared(pp_mallocator_t* a);

/*
 * returns the standard allocator working on the heap
 */
pp_mallocator_t* pp_mallocator_heap(void);

/*
 * some libc replacements, that do an internal malloc
 */
char* pp_strdup(pp_mallocator_t* a, const char* s);

#ifdef __cplusplus
};
#endif

#endif /* __MALLOCATOR_H__ */
