/*
 * rb_tree.h
 *
 * Definitions for red-black binary search tree.
 * Copyright (C) 2001 Farooq Mela.
 *
 * Adapted for Peppercon 2004, tbr@peppercon.de
 * for original code see: http://home.earthlink.net/~smela1/libdict.html
 */

#ifndef __PP_RB_TREE_H__
#define __PP_RB_TREE_H__

#include <pp/mallocator.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int   (*pp_rb_tree_cmp_func)(const void *, const void *);
typedef void* (*pp_rb_tree_dup_func)(pp_mallocator_t* a, const void *);
typedef void  (*pp_rb_tree_del_func)(pp_mallocator_t* a, void *);
typedef int   (*pp_rb_tree_vis_func)(const void *, void *);
    
typedef struct pp_rb_tree_s pp_rb_tree_t;

pp_rb_tree_t *pp_rb_tree_new (pp_rb_tree_cmp_func key_cmp,
			      pp_rb_tree_dup_func key_dup,
			      pp_rb_tree_del_func key_del);
pp_rb_tree_t *pp_rb_tree_str_new(void);
pp_rb_tree_t *pp_rb_tree_int_new(void);    
pp_rb_tree_t *pp_rb_tree_new_with_alloc (pp_rb_tree_cmp_func key_cmp,
					 pp_rb_tree_dup_func key_dup,
					 pp_rb_tree_del_func key_del,
					 pp_mallocator_t* a);
pp_rb_tree_t *pp_rb_tree_str_new_with_alloc(pp_mallocator_t* a);
void pp_rb_tree_destroy (pp_rb_tree_t *tree);

int pp_rb_tree_insert (pp_rb_tree_t *tree, const void *key, void *dat,
		       pp_rb_tree_del_func dat_del, int overwrite);
void *pp_rb_tree_search (const pp_rb_tree_t *tree, const void *key);
int pp_rb_tree_remove (pp_rb_tree_t *tree, const void *key, void** dat);
void pp_rb_tree_empty (pp_rb_tree_t *tree);
void pp_rb_tree_walk (const pp_rb_tree_t *tree, pp_rb_tree_vis_func visit);
unsigned pp_rb_tree_count (const pp_rb_tree_t *tree);
unsigned pp_rb_tree_height (const pp_rb_tree_t *tree);
unsigned pp_rb_tree_mheight (const pp_rb_tree_t *tree);
unsigned pp_rb_tree_pathlen (const pp_rb_tree_t *tree);
const void *pp_rb_tree_min (const pp_rb_tree_t *tree);
const void *pp_rb_tree_max (const pp_rb_tree_t *tree);

typedef struct pp_rb_iter_s pp_rb_iter_t;

#define PP_RB_ITER_INITIALIZER(tree) { tree, NULL }

pp_rb_iter_t *pp_rb_iter_new (const pp_rb_tree_t *tree);

int pp_rb_iter_valid (const pp_rb_iter_t *iter);
void pp_rb_iter_invalidate (pp_rb_iter_t *iter);
int pp_rb_iter_next (pp_rb_iter_t *iter);
int pp_rb_iter_prev (pp_rb_iter_t *iter);
int pp_rb_iter_nextn (pp_rb_iter_t *iter, unsigned count);
int pp_rb_iter_prevn (pp_rb_iter_t *iter, unsigned count);
int pp_rb_iter_first (pp_rb_iter_t *iter);
int pp_rb_iter_last (pp_rb_iter_t *iter);
int pp_rb_iter_search (pp_rb_iter_t *iter, const void *key);
void *pp_rb_iter_key (const pp_rb_iter_t *iter);
const void *pp_rb_iter_key_const (const pp_rb_iter_t *iter);
void *pp_rb_iter_data (const pp_rb_iter_t *iter);

/* this seems not to be implemented, currently
int pp_rb_iter_set_data (pp_rb_iter_t *iter, void *dat, int del);
int pp_rb_iter_remove (pp_rb_iter_t *iter, int del);
*/

static inline void
pp_rb_iter_destroy(pp_rb_iter_t* iter)
{
    free(iter);
}
 
#ifdef __cplusplus
}
#endif

#endif /* !_RB_TREE_H_ */
