/**
 * watchdog.h
 *
 * A simple watchdog module to monitor internal threads.
 *
 * (c) 2006 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __PP_WATCHDOG_H__
#define __PP_WATCHDOG_H__

/**
 * Registers a client at the watchdog.
 *
 * @param name    client name used for logging
 *                (will not be deep-copied, so keep the string valid!)
 * @param timeout timespan after which watchdog fires when not trigger
 * @param action  function that is called when watchdog fires (may be NULL)
 * @return client handle
 *         <0 on error
 */
int pp_wd_register(const char* name, int timeout /*secs*/, void (*action)(int id));

/**
 * Re-triggers the watchdog and transfers some context info.
 *
 * @param id  client handle (0 = identify client by thread id)
 * @param ctx any info about the context of where the trigger is called from (may be NULL)
 *            (will not be deep-copied, so keep the string valid!)
 * @return 0 on success
 *         <0 on error
 */
int pp_wd_trigger(int id, const char* ctx);

/**
 * Unregisters a client at the watchdog.
 * "action" callback is guaranteed to not be called anymore, after this functions has been returned.
 *
 * @param id client handle (0 = identify client by thread id)
 * @return 0 on success
 *         <0 on error
 */
int pp_wd_unregister(int id);

#endif // __PP_WATCHDOG_H__
