#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <pp/log.h>
#include <pp/base.h>

extern log_silent_t log_is_silent;
extern char *name;

void
pp_log(const char * format, ...)
{
    va_list args;
    char buf[256];
    time_t mytime;
    struct tm tm;

    if (log_is_silent == LOG_IS_SILENT) return;
    
    va_start(args, format);

    time(&mytime);
    strftime(buf, 255, "[%d.%m.%Y %T] ", localtime_r(&mytime, &tm));
    fprintf(stderr, "%s%s", name, buf);

    vfprintf(stderr, format, args);
    fflush(stderr);

    va_end(args);
}

void
pp_log_err(const char * format, ...)
{
    va_list args;
    char buf[256];
    time_t mytime;
    struct tm tm;
    int my_errno = errno;

    va_start(args, format);
    
    time(&mytime);
    strftime(buf, 255, "[%d.%m.%Y %T] ", localtime_r(&mytime, &tm));
    fprintf(stderr, "%s%s", name, buf);
    vfprintf(stderr, format, args);
    fprintf(stderr, ": %s\n", pp_error_string(my_errno));
    
    fflush(stderr);

    va_end(args);
    
    errno = my_errno;
}

void
pp_log_hex(char *packet, unsigned int size) {
    unsigned int i;
    for (i = 0; i < size; i++) {
	if (!(i % 16)) fprintf(stderr, "%04x: ", i);
	fprintf(stderr, "0x%02x ", ((uint8_t*) packet)[i]);
	if (!((i+1) % 16)) fprintf(stderr, "\n");
    }
    printf("\n");
}
