/**
 * Copyright 2003 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 *         I know there is some other dynamic string stuff around
 *         however I don't like that crap...
 *         On the other hand it seems pretty simple to make better,
 *         more appropriate and even fairly short stuff...
 *         so here we go... ;-)
 *
 * ATTENTION: If you wonna use these functions to allocate
 *            your memory right from the beginning, don't forget
 *            to call them with both the variables buf and buflen
 *            initialized to zero, otherwise they will crash!
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <pp/strstream.h>
#include <pp/win32.h>

#define PP_STRBUF_INCREMENT 256


static int
pp_dstr_adjustbuf(char** pBuf, size_t* pBufLen, size_t pos, size_t need) {
    if(need > *pBufLen - pos) { // buffer too small
        int inc = need < PP_STRBUF_INCREMENT ? PP_STRBUF_INCREMENT : need;
        if(NULL == (*pBuf = realloc(*pBuf, *pBufLen += inc))) {
            return -1;
	}
	return 1;
    }
    return 0;
}


char*
pp_dstrcpy(char** pBuf, size_t* pBufLen, size_t pos,
	   const char* str, size_t *ncpy) {
    size_t n = strlen(str);
    if(0 > pp_dstr_adjustbuf(pBuf, pBufLen, pos, n + 1))
	return 0;
    strcpy(*pBuf + pos, str);
    if (ncpy != NULL) *ncpy = n;
    return *pBuf;
}

char* 
pp_dstrncpy(char** pBuf, size_t* pBufLen, size_t pos,
	    const char* str, size_t n) {
    if(0 > pp_dstr_adjustbuf(pBuf, pBufLen, pos, n))
	return 0;
    strncpy(*pBuf + pos, str, n);
    return *pBuf;
}

int
pp_dchrcpy(char** pBuf, size_t* pBufLen, size_t pos, char chr) {
    if(0 > pp_dstr_adjustbuf(pBuf, pBufLen, pos, 1))
	return 0;
    *(*pBuf + pos++) = chr;
    return 1;
}

char*
pp_dstrcat(char** pBuf, size_t* pBufLen, const char* str) {
    if(0 > pp_dstr_adjustbuf(pBuf, pBufLen, strlen(*pBuf), strlen(str) + 1))
	return 0;
    return strcat(*pBuf, str);
}

void*
pp_dstrwrite(char** pBuf, size_t* pBufLen, size_t pos, const char* data, size_t len) {
    if(0 > pp_dstr_adjustbuf(pBuf, pBufLen, pos, len))
	return NULL;
    return memcpy(&(*pBuf)[pos], data, len);
}

int
pp_dvsprintf(char** pBuf, size_t* pBufLen, size_t pos,
	     const char *format, va_list ap) {
    int b; size_t need, n;
    va_list aq;
    va_copy(aq, ap);
    need = (n = vsnprintf(*pBuf + pos, *pBufLen - pos, format, ap)) + 1;
    if (0 > (b = pp_dstr_adjustbuf(pBuf, pBufLen, pos, need))) {
	n = 0;   // ralloc error
    } else if (b) { // pBuf was reallocated
	n = vsnprintf(*pBuf + pos, *pBufLen - pos, format, aq);
	assert(need < (*pBufLen - pos));
    }
    va_end(aq);
    return n;
}

int
pp_dsprintf(char** pbuf, size_t* pbuflen, size_t pos, const char *format, ...){
    va_list ap;
    int n;
    va_start(ap, format);
    n = pp_dvsprintf(pbuf, pbuflen, pos, format, ap);
    va_end(ap);
    return n;
}

/*
 * nice little string stream functions
 * based on the dynamic print functions
 */
pp_strstream_t* pp_strstream_init(pp_strstream_t* stream) {
    if (NULL == stream) {
	if (NULL == (stream = malloc(sizeof(pp_strstream_t)))) {
	    return NULL;
	}
	stream->on_heap = 1;
    } else {
	stream->on_heap = 0;
    }
    stream->buf     = NULL;
    stream->buflen  = 0;
    stream->pos     = 0;
    return stream;
}

char* pp_strstream_buf(pp_strstream_t* stream) {
    pp_strappendchr(stream, '\0');
    stream->pos--;
    return stream->buf;
}

void pp_strstream_free(pp_strstream_t* stream) {
    if(stream == NULL)
	return;
    if(stream->buf != NULL)
	free(stream->buf);
    if(stream->on_heap)
	free(stream);
}

/* frees all but `buf' and returns `buf' */
char*
pp_strstream_buf_and_free(pp_strstream_t* stream)
{
    char *ret = pp_strstream_buf(stream);
    if(stream->on_heap) free(stream);
    return ret;
}
   
int pp_strappend(pp_strstream_t* stream, const char* str) {
    size_t n = 0;
    pp_dstrcpy(&stream->buf, &stream->buflen, stream->pos, str, &n);
    stream->pos += n;
    return n;
}

int pp_strappendn(pp_strstream_t* stream, const char* str, size_t n) {
    pp_dstrncpy(&stream->buf, &stream->buflen, stream->pos, str, n);
    stream->pos += n;
    return n;
}

// ATTENTION: does not append a trailing '\0'!!!
int pp_strappendchr(pp_strstream_t* stream, char chr) {
    int n = pp_dchrcpy(&stream->buf, &stream->buflen, stream->pos, chr);
    stream->pos += n;
    return n;
}

int pp_strappendf(pp_strstream_t* stream, const char* format, ...) {
    va_list ap;
    int n;
    va_start(ap, format);
    n = pp_dvsprintf(&stream->buf, &stream->buflen, stream->pos, format, ap);
    va_end(ap);
    stream->pos += n;
    return n;
}

int pp_strwrite(pp_strstream_t* stream, const char* data, size_t n) {
    pp_dstrwrite(&stream->buf, &stream->buflen, stream->pos, data, n);
    stream->pos += n;
    return n;
}

int pp_vstrappendf(pp_strstream_t* stream, const char* format, va_list args) {
    int n;
    n = pp_dvsprintf(&stream->buf, &stream->buflen, stream->pos, format, args);
    stream->pos += n;
    return n;
}

/*
 * any character in the delis string will be replaced by
 * "\<index of character in delis string>"
 * and a single '\' will be replaced by "\\"
 *
 * i.e. that means, currently that means, the following has
 * to be true: strlen(delis) < 10
 */
void pp_strencode(const char* delis, pp_strstream_t* os, const char* s) {
    char c, d; int i;
    assert(strlen(delis) < 10);
    while ((c = *s++) != '\0') {
	if (c == '\\') {
	    pp_strappend(os, "\\\\");
	} else {
	    for (i = 0; (d = delis[i]) != '\0'; ++i) {
		if (c == d) {
		    pp_strappendf(os, "\\%d", i);
		    break;
		}
	    }
	    if (d == '\0') { // if ended at its end, do default
		pp_strappendchr(os, c);
	    }
	}
    }
}

/*
 * that is the opposite of the function above, so make sure
 * to pass the same delis strings that contains the delis
 * in the same order, otherwise strange things will happen
 */
void pp_strdecode(const char* delis, pp_strstream_t* os, const char* s) {
    char c, d;
    assert(strlen(delis) < 10);
    while ((c = *s++) != '\0') {
	if (c == '\\') {
	    d = *s++;
	    if (d == '\0') {
		break;
	    } else if (d == '\\') {
		pp_strappendchr(os, d);
	    } else {
		pp_strappendchr(os, delis[d - 48]);
	    }
	} else {
	    pp_strappendchr(os, c);
	}
    }
}
