#include <pp/base.h>
#include <liberic_pthread.h>
#include <sys/time.h>

int
eric_pthread_create(pthread_t * thread, int detached, size_t stack_size,
		    void * (*start_routine)(void *), void * arg)
{
    pthread_attr_t attr;
    int r;
    
    /* create the thread */
    if ((r = pthread_attr_init(&attr)) != 0) {
	pp_log("Cannot initialize thread attributes (%s).\n",
		 strerror(r));
	goto finish;
    }

    if ((r = pthread_attr_setstacksize(&attr, stack_size)) != 0) {
	pp_log("Cannot set thread stack size (%s).\n", strerror(r));
	goto finish;
    }

    if (detached &&
	(r = pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED))) {
	pp_log("Cannot set thread stack size (%s).\n", strerror(r));
	goto finish;

    }

    r = pthread_create(thread, &attr, start_routine, arg);

 finish:
    return r;
}

