

#include <stdio.h>
#include <pp/base.h>
#include <pp/rbuf.h>

int main(int argc UNUSED, char** argv UNUSED) {
    const char* t = "1234567890";
    char buf[32];
    size_t n;
    int ovfl, i;

    pp_rbuf_t* rbuf = pp_rbuf_create(8, 1);
    
    for (i = 0; i < 10; ++i) {
	printf("*** %d\n", i);

	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));
	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));
	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));
	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));
	printf("space = %zd\n", pp_rbuf_space(rbuf));

	n = pp_rbuf_remove(rbuf, &ovfl, buf, 5);
	buf[n] = '\0';
	printf("remove[ovfl=%d] = %zd (%s)\n", ovfl, n, buf);

	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));
	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 4));

	n = pp_rbuf_remove(rbuf, &ovfl, buf, 5);
	buf[n] = '\0';
	printf("remove[ovfl=%d] = %zd (%s)\n", ovfl, n, buf);
	printf("size = %zd\n", pp_rbuf_size(rbuf));
	printf("space = %zd\n", pp_rbuf_space(rbuf));
	n = pp_rbuf_remove(rbuf, &ovfl, buf, 5);
	buf[n] = '\0';
	printf("remove[ovfl=%d] = %zd (%s)\n", ovfl, n, buf);
	n = pp_rbuf_remove(rbuf, &ovfl, buf, 5);
	buf[n] = '\0';
	printf("remove[ovfl=%d] = %zd (%s)\n", ovfl, n, buf);

	printf("append = %zd\n", pp_rbuf_append(rbuf, t, 2));

	n = pp_rbuf_remove(rbuf, &ovfl, buf, 1);
	buf[n] = '\0';
	printf("remove[ovfl=%d] = %zd (%s)\n", ovfl, n, buf);

    }

    pp_rbuf_destroy(rbuf);

    return 0;
}
