#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <pthread.h>
#include <pp/base.h>
#include <pp/termios.h>
#include <pp/selector.h>

int handle_timer(const int item_id UNUSED, void* ctx UNUSED) {
		printf("Timer %d handled!!!\n", item_id);
    return 0;
}


int open_tty() {
    int fd = 0;
    if (0 > (fd = open("/dev/ttyS0", O_RDWR | O_NONBLOCK)))
	perror("open(/dev/ttyS0)");
    if (0 > pp_base_set_tty_params(fd, 4800, "", 8, 0, 0, 0))
	perror("pp_base_set_tty_params");
    return fd;
}

int handle_tty(const int item_id UNUSED, const int fd, 
		const short event UNUSED, void* ctx UNUSED) {
    char buf[1024];
    int c;
    printf("tty: ");

    if (0 > (c = read(fd, buf, sizeof(buf)))) {
	perror("read error");
    } else {
	buf[c] = '\0';
	printf("%s\n", buf);
    }
    return 0;
}

int handle_input(const int item_id UNUSED, const int fd, 
		 const short event UNUSED, void* ctx UNUSED) {
    char buf[1024];
    int c;
    static int fdh = 0;
    printf("input: ");

    if (0 > (c = read(fd, buf, sizeof(buf)))) {
	perror("read error");
    } else {
	buf[c] = '\0';
	printf("%s", buf);
	switch (buf[0]) {
	case 'a': 
	    pp_select_add_to(1000 * atoi(&buf[1]), 0, handle_timer, NULL);
	    break;
	case 'r':
	    pp_select_add_to(1000 * atoi(&buf[1]), 1, handle_timer, NULL);
	    break;
	case 'd':
	    pp_select_remove_to(atoi(&buf[1]));
	    break;
	case 'x':
	    pp_select_interrupt();
	    break;
	case 'o':
	    fdh = pp_select_add_fd(open_tty(), POLLIN, handle_tty, NULL);
	    break;
	case 'c':
	    pp_select_remove_fd(fdh);
	    break;
	}
    }
    return 0;
}

int handle_scheduled(void* ctx) {
    printf("scheduled %ld\n", (long)ctx);
    return 0;
}

int tterm = 0;

void* thread_func(void* arg UNUSED) {
    long i;
    for (i = 0; !tterm ; i+=10) {
	sleep(2);
	pp_select_add_sf(handle_scheduled, (void*)i++);
	pp_select_add_sf(handle_scheduled, (void*)i++);
	pp_select_add_sf(handle_scheduled, (void*)i++);
	pp_select_add_sf(handle_scheduled, (void*)i++);
	pp_select_add_sf(handle_scheduled, (void*)i++);
    }
    return NULL;
}

int main() {

    pthread_t t;
    int err;
    
    printf("Running selector test.. \n");

    if (PP_SUC != pp_select_init()) {
	perror("pp_select_init");
	exit (1);
    }
    
    pp_select_add_fd(0, POLLIN, handle_input, NULL);
    //pp_select_add_to(1000, 1, handle_timer, NULL);

    if (0 != (err = pthread_create(&t, NULL, thread_func, NULL))) {
	errno = err;
	perror("pthread_create");
    }

    pp_select_loop();

    tterm = 1;
    if (0 != (err = pthread_join(t, NULL))) {
	errno = err;
	perror("pthread_join");
    }

    pp_select_cleanup();
    
    return 0;
}
