#include <unistd.h>
#include <pp/timerq.h>

int ring(void *ctx) {
    char *c = (char*)ctx;
    printf("woke up, message is '%s'\n", c);
}

int main() {
    pp_timerq_t* tq = pp_timerq_create();
    int ret;
    
    printf("starting timerq\n");
    pp_timerq_start(tq);
    
    printf("adding timer 1, 200msec\n");
    pp_timerq_add(tq, 200, ring, "timer 1, 200msec");
    printf("adding timer 2, 100msec\n");
    pp_timerq_add(tq, 100, ring, "timer 2, 100msec");
    
    printf("stopping timerq\n");
    pp_timerq_stop(tq);
    
    printf("now wait a while\n"
           "timer 1 and 2 should not wake up until timerq restart\n");
    sleep(2);
    printf("starting timerq\n");
    pp_timerq_start(tq);
    
    printf("adding timer 1, 200msec\n");
    pp_timerq_add(tq, 200, ring, "timer 1, 200msec");
    printf("adding timer 2, 100msec\n");
    pp_timerq_add(tq, 100, ring, "timer 2, 100msec");
    printf("adding timer 3, 5000msec\n");
    pp_timerq_add(tq, 5000, ring, "timer 3, 5000msec");
    usleep(1);
    printf("adding timer 4, 100msec\n");
    ret = pp_timerq_add(tq, 100, ring, "timer 4, 100msec");
    printf("adding timer 5, 100msec\n");
    pp_timerq_add(tq, 100, ring, "timer 5, 100msec");
    printf("adding timer 6, 200msec\n");
    pp_timerq_add(tq, 200, ring, "timer 6, 200msec");
    printf("removing timer 4... %s\n", 
           pp_timerq_rem(tq, ret) == 0 ? "succeeded" : "failed");

    sleep(6);
    printf("stopping timerq\n");
    pp_timerq_stop(tq);
    
    pp_timerq_destroy(tq);
    
    return 0;
}
