/**
 * Copyright 2001 Peppercon AG
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 *
 * Description: little string tokenizer for parsing
 *              strings
 */

#include <string.h>
#include <malloc.h>
#include <pp/tokenizer.h>

/*
 * initializes a new tokenizer structure
 * the string given to the tokenizer is going
 * to be destroyed by it. Means the tokenizer
 * is not allocating new memory for the Tokens
 * returned by the Tokenizer.
 * There might be multiple delemitters, all given
 * in the single string delis
 * The retdeli boolean defines, whether delemiters are
 * also returned as tokens or not
 */
tokenizer_t* tokenizer_new(tokenizer_t* tok,
			   char* string, const char* delis, int retdeli) {
    tok->delis = delis;
    tok->next = string;
    tok->skipdeli = retdeli ? 0 : 1;
    tok->ondeli = 0;
    tok->cdeli = string[0];
    return tok;
}

/*
 * checks whether there anothter token available
 */
int tokenizer_has_next(tokenizer_t* tok) {
    return tok->next != NULL;
}

/*
 * get next token from the tokenizer overgiven to
 * the function
 */
char* tokenizer_get_next(tokenizer_t* tok) {
    char *p, *tmp = tok->next;
    if(!tok->skipdeli) *tmp = tok->cdeli;
    if(tok->ondeli) {                                // return deli
	tok->cdeli = *++tok->next;
	*tok->next = '\0';
	tok->ondeli = 0;
    } else {                                         // look for token
	if(NULL == (p = strpbrk(tmp, tok->delis))) { // no more tokens
	    tok->next = NULL;
	} else {                                     // seperate tokens
	    tok->next = p + tok->skipdeli;
	    tok->ondeli = !tok->skipdeli;
	    tok->cdeli = *p;
	    *p = '\0';
	}
    }
    return tmp;
}
