#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <pp/base.h>
#include <pp/bio_internal.h>

int _pp_bio_get_host_ip(const char *str, unsigned char *ip, int addr_family)
{
    const char * fn = ___F;
    int i;
    int err = 1;
    struct hostent * hp;

    if (addr_family != AF_INET && addr_family != AF_INET6) return 0;

    if ((i = inet_pton(addr_family, str, ip)) < 0) {
	pp_log_err("%s(): Couldn't create network address structure", fn);
	goto err;
    } else if (i > 0) {
	return 1;
    }

    /* FIXME: not threadsafe - use gethostbyname2_r! */
    if ((hp = gethostbyname2(str, addr_family)) == NULL) {
	pp_log("%s(): Hostname lookup failed: %s\n", fn, hstrerror(h_errno));
        goto err;
    }

    if (hp->h_addrtype != addr_family) {
	pp_log("%s(): Socket address family mismatch\n", fn);
        goto err;
    }
    for (i = 0; i < hp->h_length; i++)
        ip[i] = hp->h_addr_list[0][i];
    err = 0;

 err:
    return err ? 0 : 1;
}
