#ifndef _PP_BIO_H
#define _PP_BIO_H

#include <netinet/in.h>
#include <openssl/bio.h>
#include <openssl/evp.h>

#define BIO_TYPE_PP_ACCEPT	(30|BIO_TYPE_SOURCE_SINK|BIO_TYPE_DESCRIPTOR)
#define BIO_TYPE_PP_CONNECT	(31|BIO_TYPE_SOURCE_SINK|BIO_TYPE_DESCRIPTOR)
#define BIO_TYPE_PP_RFB_CHECK	(32|BIO_TYPE_FILTER)
#define BIO_TYPE_PP_ESB2_TPT	(33|BIO_TYPE_SOURCE_SINK|BIO_TYPE_DESCRIPTOR)

#define BIO_C_PP_SET_CHECK_CALLBACK	200
#define BIO_C_PP_CHECK_RFB		201

#define BIO_PP_PROTO_MSP	3
#define BIO_PP_PROTO_RFB	2
#define BIO_PP_PROTO_HTTPS	1
#define BIO_PP_PROTO_NONE	0

typedef int (*pp_bio_rfb_check_callback_t)(void * data, size_t data_size);

#ifdef __cplusplus
extern "C" {
#endif

int pp_bio_init(void);
void pp_bio_cleanup(void);

BIO_METHOD * BIO_pp_s_accept(void);
BIO * pp_bio_new_accept(char * host_port, int addr_family);

BIO_METHOD * BIO_pp_s_connect(void);
BIO * pp_bio_new_connect(char * host_port, int addr_family, long io_timeout);

BIO_METHOD * BIO_pp_f_rfb_check(void);
BIO * pp_bio_new_rfb_check(pp_bio_rfb_check_callback_t check_cb);
#define pp_bio_do_rfb_check(bio) BIO_ctrl(bio, BIO_C_PP_CHECK_RFB, 0, NULL)

#ifdef PP_FEAT_ESB2_TPT
extern BIO_METHOD * BIO_pp_esb2_tpt(void);
extern BIO * pp_bio_new_esb2_tpt(int fd, int close_flag);
#endif

int pp_bio_get_peer_name(BIO * bio, char * ip_buf, size_t ip_buf_size);
int pp_bio_set_md(BIO * bio, const EVP_MD * md);

int pp_rfb_check_cb(void * data, size_t data_size);

#ifdef __cplusplus
}
#endif

#endif /* _PP_BIO_H */
