/*
 * goes through a list of types and tags the section this
 * list belongs to into the type field of pp_cd_as_type_t
 *
 * tbr@peppercon.de
 * (c) 2004 Peppercon AG
 */

#include <stdio.h>
#include <stdlib.h>
#include <pp/cd.h>

static int
tagsec_for_type(pp_cd_as_type_t* type, pp_cd_as_op_t* op UNUSED, void* ctx) {
    type->base.type |= (pp_cd_as_id_t)ctx;
    return 0;
}

static int
tagsec_for_type_struct(pp_cd_as_type_struct_t* s, pp_cd_as_op_t* op,
			  void* ctx) {
    s->base.base.type |= (pp_cd_as_id_t)ctx;
    pp_cd_op_list(s->elements, op, ctx);
    return 0;
}
    
static int
tagsec_for_type_choice_tmpl(pp_cd_as_type_choice_tmpl_t* ct,
			       pp_cd_as_op_t* op, void* ctx) {
    ct->base.base.type |= (pp_cd_as_id_t)ctx;
    pp_cd_op_list(ct->elements, op, ctx);
    return 0;
}
    

pp_cd_as_op_t pp_cd_as_op_tagsec = {
    NULL,
    NULL,
    tagsec_for_type,
    (int(*)(pp_cd_as_type_alias_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    tagsec_for_type_struct,
    (int(*)(pp_cd_as_type_enum_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    (int(*)(pp_cd_as_type_string_tmpl_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    (int(*)(pp_cd_as_type_int_tmpl_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    tagsec_for_type_choice_tmpl,
    (int(*)(pp_cd_as_type_vector_tmpl_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    (int(*)(pp_cd_as_type_vector_tmpl_spec_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    (int(*)(pp_cd_as_type_vector_tmpl_inst_t*, pp_cd_as_op_t*, void*))tagsec_for_type,
    NULL,
    NULL,
    NULL,
    NULL
};
