#include <pp/cd.h>
#include <cd_intern.h>

static int
type_compare_list(vector_t* v, pp_cd_as_op_t* op, void* ctx) {
    unsigned int i, v_sz;
    vector_t* v2 = (vector_t*)ctx;
    
    if((v_sz = vector_size(v)) != vector_size(v2))
        return PP_ERR;
    
    for (i = 0; i < vector_size(v); ++i) {
        pp_cd_as_t* o = (pp_cd_as_t*)vector_get(v, i);
        void *o2 = (void*)vector_get(v2, i);
        if(PP_ERR == o->execute(o, op, o2))
            return PP_ERR;
    }
    
    return PP_SUC;
}

static int
type_compare_for_type_fund (pp_cd_as_type_t* type, pp_cd_as_op_t* op UNUSED, 
			    void* ctx) {
    pp_cd_as_type_t* type2 = (pp_cd_as_type_t*)ctx;
    
    if(strcmp(type->name, type2->name))
        return PP_ERR;
    
    return PP_SUC;
}

static int
type_compare_for_type_alias(pp_cd_as_type_alias_t* a, pp_cd_as_op_t* op UNUSED,
			    void* ctx) {
    pp_cd_as_type_alias_t* a2 = (pp_cd_as_type_alias_t*)ctx;
    
    if(strcmp(a->ref_type_name, a2->ref_type_name))
        return PP_ERR;
    
    return a->ref_type->base.execute((pp_cd_as_t*)a->ref_type, op,
                                     (void*)a2->ref_type);
}

static int
type_compare_for_type_struct(pp_cd_as_type_struct_t* s, pp_cd_as_op_t* op,
			 void* ctx) {
    pp_cd_as_type_struct_t* s2 = (pp_cd_as_type_struct_t*)ctx;
    return type_compare_list(s->elements, op, (void*)s2->elements);
}
    
static int
type_compare_for_type_enum(pp_cd_as_type_enum_t* e, pp_cd_as_op_t* op,
		       void* ctx) {
    pp_cd_as_type_enum_t* e2 = (pp_cd_as_type_enum_t*)ctx;
    return type_compare_list(e->elements, op, e2->elements);
}

static int
type_compare_for_type_string_tmpl(pp_cd_as_type_string_tmpl_t* st,
			      pp_cd_as_op_t* op UNUSED, void* ctx) {
    pp_cd_as_type_string_tmpl_t* st2 = (pp_cd_as_type_string_tmpl_t*)ctx;
    
    if(st->min != st2->min || st->max != st2->max ||
       strcmp(st->regexp, st2->regexp))
        return PP_ERR;
        
    return PP_SUC;
}

static int
type_compare_for_type_int_tmpl(pp_cd_as_type_int_tmpl_t* it, 
			   pp_cd_as_op_t* op UNUSED, void* ctx) {
    pp_cd_as_type_int_tmpl_t* it2 = (pp_cd_as_type_int_tmpl_t*)ctx;
    
    if(it->min != it2->min || it->max != it2->max)
        return PP_ERR;
        
    return PP_SUC;
}

static int
type_compare_for_type_choice_tmpl(pp_cd_as_type_choice_tmpl_t* ct,
			      pp_cd_as_op_t* op, void* ctx) {
    pp_cd_as_type_choice_tmpl_t* ct2 = (pp_cd_as_type_choice_tmpl_t*)ctx;
    
    if(PP_SUC != ct->tmpl_type->base.execute((pp_cd_as_t*)ct->tmpl_type, op,
                                             (void*)ct2->tmpl_type) ||
       PP_SUC != type_compare_list(ct->elements, op, ct2->elements))
        return PP_ERR;

    return PP_SUC;
}
    
static int
type_compare_for_type_vector_tmpl(pp_cd_as_type_vector_tmpl_t* v,
			      pp_cd_as_op_t* op UNUSED, void* ctx) {
    pp_cd_as_type_vector_tmpl_t* v2 = (pp_cd_as_type_vector_tmpl_t*)ctx;
    
    if(v->idx_type != v2->idx_type || v->bound != v2->bound ||
       strcmp(v->elem_type_name, v2->elem_type_name))
        return PP_ERR;
       
    return v->elem_type->base.execute((pp_cd_as_t*)v->elem_type, op,
                                      (void*)v2->elem_type);
}

static int
type_compare_for_enumerator(pp_cd_as_enumerator_t* er, pp_cd_as_op_t* op UNUSED,
			void* ctx) {
    pp_cd_as_enumerator_t* er2 = (pp_cd_as_enumerator_t*)ctx;
    
    if(strcmp(er->value, er2->value))
        return PP_ERR;
    
    return PP_SUC;
}

pp_cd_as_op_t pp_cd_as_op_type_compare = {
    NULL,
    NULL,
    type_compare_for_type_fund,
    type_compare_for_type_alias,
    type_compare_for_type_struct,
    type_compare_for_type_enum,
    type_compare_for_type_string_tmpl,
    type_compare_for_type_int_tmpl,
    type_compare_for_type_choice_tmpl,
    type_compare_for_type_vector_tmpl,
    NULL,
    NULL,
    type_compare_for_enumerator,
    NULL,
    NULL,
    NULL
};

