/*
 * operation to dump defines from a configuration description into a file
 *
 * tweb@peppercon.de
 * (c) 2005 Peppercon AG
 */

#include <stdio.h>
#include <ctype.h>
#include <pp/cd.h>
#include "xdefs_internal.h"

static const char xdef_deli_str = '_';

static void write_define(const char *name, const char *value, void *ctx) {
    xdef_ctx_t *xctx;
    
    xctx = (xdef_ctx_t*)ctx;
    fprintf(xctx->header, "extern const char *PP_CD_%s_STR;\n", name);
    fprintf(xctx->source, "const char *PP_CD_%s_STR = \t\"%s\";\n",
            name, value);
}

static void strappend_upper(pp_strstream_t* stream, const char* str) {
    const char *p;
    
    assert(str);
    for(p = str; *p; ++p)
        pp_strappendchr(stream, toupper(*p));
}

static int
xdef_for_cd(pp_cd_as_cd_t* cd,  pp_cd_as_op_t* op, void* ctx) {
    pp_strstream_t strbuf;
    xdef_ctx_t *xctx;
    
    xctx = (xdef_ctx_t*)ctx;
    xctx->strbuf = &strbuf;
    pp_strstream_init(xctx->strbuf);

    fprintf(xctx->header, "#ifndef __PP_CD_XDEFS_H__\n"
                          "#define __PP_CD_XDEFS_H__\n");
    pp_cd_op_cd(cd, op, (void*)xctx);
    fprintf(xctx->header, "#endif /* __PP_CD_XDEFS_H__ */\n");
    
    return 0;
}
    
static int
xdef_for_section(pp_cd_as_section_t* s, pp_cd_as_op_t* op, void* ctx) {
    pp_cd_op_list(s->decls, op, ctx);
    return 0;
}

static int
xdef_for_type(pp_cd_as_type_t* type UNUSED, pp_cd_as_op_t* op UNUSED, 
              void* ctx UNUSED) {
    return 0;
}

static int
xdef_for_type_alias(pp_cd_as_type_alias_t* a UNUSED, pp_cd_as_op_t* op UNUSED,
                    void* ctx UNUSED) {
    return 0;
}

static int
xdef_for_type_struct(pp_cd_as_type_struct_t* s, pp_cd_as_op_t* op, void* ctx) {
    xdef_ctx_t *xctx;
    int pos;
    
    xctx = (xdef_ctx_t*)ctx;
    pos = pp_strstream_pos(xctx->strbuf);
    
    if(pos)
        pp_strappendchr(xctx->strbuf, xdef_deli_str);
    strappend_upper(xctx->strbuf, s->base.name);
    pp_cd_op_list(s->elements, op, ctx);
    pp_strstream_seek(xctx->strbuf, pos);
    return 0;
}
    
static int
xdef_for_type_enum(pp_cd_as_type_enum_t* e, pp_cd_as_op_t* op, void* ctx) {
    xdef_ctx_t *xctx;
    int pos;
    
    xctx = (xdef_ctx_t*)ctx;
    pos = pp_strstream_pos(xctx->strbuf);
    
    if(pos)
        pp_strappendchr(xctx->strbuf, xdef_deli_str);
    strappend_upper(xctx->strbuf, e->base.name);
    pp_cd_op_list(e->elements, op, ctx);
    pp_strstream_seek(xctx->strbuf, pos);
    return 0;
}

static int
xdef_for_type_string_tmpl(pp_cd_as_type_string_tmpl_t* st UNUSED,
	  	          pp_cd_as_op_t* op UNUSED, void* ctx UNUSED) {
    return 0;
}

static int
xdef_for_type_int_tmpl(pp_cd_as_type_int_tmpl_t* it UNUSED,
                       pp_cd_as_op_t* op UNUSED, void* ctx UNUSED) {
    return 0;
}

static int
xdef_for_type_choice_tmpl(pp_cd_as_type_choice_tmpl_t* ct,
			  pp_cd_as_op_t* op, void* ctx) {
    xdef_ctx_t *xctx;
    int pos;
    
    xctx = (xdef_ctx_t*)ctx;
    pos = pp_strstream_pos(xctx->strbuf);
    
    if(pos)
        pp_strappendchr(xctx->strbuf, xdef_deli_str);
    strappend_upper(xctx->strbuf, ct->base.name);
    pp_cd_op_list(ct->elements, op, ctx);
    pp_strstream_seek(xctx->strbuf, pos);
    return 0;
}
    
static int
xdef_for_type_vector_tmpl(pp_cd_as_type_vector_tmpl_t* v UNUSED,
                          pp_cd_as_op_t* op UNUSED, void* ctx UNUSED) {
    return 0;
}
    
static int
xdef_for_type_vector_tmpl_spec(pp_cd_as_type_vector_tmpl_spec_t* v UNUSED, 
                               pp_cd_as_op_t* op UNUSED, void* ctx UNUSED) {
    return 0;
}

static int
xdef_for_type_vector_tmpl_inst(pp_cd_as_type_vector_tmpl_inst_t* v UNUSED,
                               pp_cd_as_op_t* op UNUSED, void* ctx UNUSED) {
    return 0;
}
    
static int 
xdef_for_enumerator(pp_cd_as_enumerator_t* er, pp_cd_as_op_t* op UNUSED,
                    void* ctx) {
    xdef_ctx_t *xctx;
    int pos;
    
    xctx = (xdef_ctx_t*)ctx;
    pos = pp_strstream_pos(xctx->strbuf);

    if(pos)
        pp_strappendchr(xctx->strbuf, xdef_deli_str);
    strappend_upper(xctx->strbuf, er->value);
    write_define(pp_strstream_buf(xctx->strbuf), er->value, ctx);
    pp_strstream_seek(xctx->strbuf, pos);
    return 0; 
}

pp_cd_as_op_t pp_cd_as_op_xdefs = {
    xdef_for_cd,
    xdef_for_section,
    xdef_for_type,
    xdef_for_type_alias,
    xdef_for_type_struct,
    xdef_for_type_enum,
    xdef_for_type_string_tmpl,
    xdef_for_type_int_tmpl,
    xdef_for_type_choice_tmpl,
    xdef_for_type_vector_tmpl,
    xdef_for_type_vector_tmpl_spec,
    xdef_for_type_vector_tmpl_inst,
    xdef_for_enumerator,
    NULL,
    NULL,
    NULL
};

