/*
 * operation to dump a configuration description
 * (mainly intended for debugging purposes)
 *
 * tbr@peppercon.de
 * (c) 2004 Peppercon AG
 */

#include <stdio.h>
#include <stdlib.h>
#include <pp/cd.h>

#include "as_op_i18n_internal.h"

static int
print_for_cd(pp_cd_as_cd_t* cd,  pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    ctx->cd = cd;
    pp_cd_op_cd(cd, op, (void*)ctx);
    return 0;
}
    
static int
print_for_section(pp_cd_as_section_t* s, pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    pp_cd_op_list(s->decls, op, (void*)ctx);
    return 0;
}

static int
print_for_type(pp_cd_as_type_t* type, pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (type->properties) {
	pp_cd_op_list(type->properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_alias(pp_cd_as_type_alias_t* a, pp_cd_as_op_t* op,
			 void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (a->base.properties) {
	pp_cd_op_list(a->base.properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_struct(pp_cd_as_type_struct_t* s, pp_cd_as_op_t* op,
			  void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    pp_cd_op_list(s->elements, op, (void*)ctx);
    if (s->base.properties) {
	pp_cd_op_list(s->base.properties, op, (void*)ctx);
    }
    return 0;
}
    
static int
print_for_type_enum(pp_cd_as_type_enum_t* e, pp_cd_as_op_t* op,
			void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    pp_cd_op_list(e->elements, op, (void*)ctx);
    if (e->base.properties) {
	pp_cd_op_list(e->base.properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_string_tmpl(pp_cd_as_type_string_tmpl_t* st,
			       pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (st->base.properties) {
	pp_cd_op_list(st->base.properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_int_tmpl(pp_cd_as_type_int_tmpl_t* it, pp_cd_as_op_t* op,
			    void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (it->base.properties) {
	pp_cd_op_list(it->base.properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_choice_tmpl(pp_cd_as_type_choice_tmpl_t* ct,
			       pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    pp_cd_op_list(ct->elements, op, (void*)ctx);
    if (ct->base.properties) {
	pp_cd_op_list(ct->base.properties, op, (void*)ctx);
    }
    return 0;
}
    
static int
print_for_type_vector_tmpl(pp_cd_as_type_vector_tmpl_t* v,
			       pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (v->base.properties) {
	pp_cd_op_list(v->base.properties, op, (void*)ctx);
    }
    return 0;
}
    
static int
print_for_type_vector_tmpl_spec(pp_cd_as_type_vector_tmpl_spec_t* v, 
				    pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (v->base.properties) {
	pp_cd_op_list(v->base.properties, op, (void*)ctx);
    }
    return 0;
}

static int
print_for_type_vector_tmpl_inst(pp_cd_as_type_vector_tmpl_inst_t* v,
				    pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (v->base.properties) {
	pp_cd_op_list(v->base.properties, op, (void*)ctx);
    }
    return 0;
}
    
static int
print_for_enumerator(pp_cd_as_enumerator_t* er, pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    if (er->properties) {
	pp_cd_op_list(er->properties, op, (void*)ctx);
    }
    return 0; 
}
 
static int
print_for_property(pp_cd_as_property_t* p, pp_cd_as_op_t* op UNUSED, 
		   void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    
    // print the description which should be translated into the translation file
    if (!strcmp(p->key, "desc") && (p->base.type & AS_MISC) == AS_PROPERTY_STRING) {
        fprintf(ctx->fp, "_(\"%s\")\n", p->value.text);
    }
    
    return 0; 
}

static int
print_for_fkt_decl(pp_cd_as_fkt_decl_t* fd, pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;
    pp_cd_as_type_t* fd_base;

    if (fd->params) {
        pp_cd_op_list(fd->params, op, (void *)(ctx));
    }
    fd_base = (pp_cd_as_type_t*)fd;
    if (fd_base->properties) {
        pp_cd_op_list(fd_base->properties, op, (void*)ctx);
    }
    return 0;
}

/* skip over all the indices and choice keys of a cfg key to get the typename */
static char* cfg_var_to_qid(const char* cfgkey, char* tname, size_t tnamelen) {
    const char *p = cfgkey;
    char c, *t = tname, *lt = tname + tnamelen - 1;
    int skipping = 0;
    while((c = *p++) != '\0') {
	if (skipping) {
	    if (c == ']') skipping = 0;
	} else {
	    if (c == '[') skipping = 1;
            /* skip choice keys */
            else if (c == '.' && *p == '_' && *(p + 1) == 'c' && 
                     *(p + 2) == '_') p += 3;
	    else if (t < lt) *t++ = c;
	    else break;
	}
    }
    *t = '\0';
    return tname;
}

static int
print_for_value_expr(pp_cd_as_value_expr_t* ve, pp_cd_as_op_t* op, void* _ctx) {
    i18n_ctx_t *ctx = (i18n_ctx_t *)_ctx;

    char* qkey = pp_cd_qualikey_to_string(NULL, ve->qkey);
    char* qkey_full = pp_cd_qualikey_to_string(ctx->parent_key, ve->qkey);
    
    // recursively dive into the list
    if ((ve->base.type & AS_EXPR) == AS_EXPR_VALUE_LIST) {
        const char *last_parent_key = ctx->parent_key;
        ctx->parent_key = qkey_full;
        pp_cd_op_list(ve->value.listval, op, (void*)(ctx));
        ctx->parent_key = last_parent_key;
    }
    
    if ((ve->base.type & AS_EXPR) == AS_EXPR_ENUM_LITERAL || (ve->base.type & AS_EXPR) == AS_EXPR_STRING_LITERAL) {
        size_t l = strlen(qkey_full + 1);
        char qid[l];
        cfg_var_to_qid(qkey_full, qid, l);
        
        // if the key has the "translate" flag, write it into the translation file
        if (pp_cd_prop_has_flag(ctx->cd, qid, "flags", "translate")) {
            fprintf(ctx->fp, "_(\"%s\")\n", ve->value.stringval);
        }
    }
    return 0;
}

pp_cd_as_op_t pp_cd_as_op_i18n = {
    print_for_cd,
    print_for_section,
    print_for_type,
    print_for_type_alias,
    print_for_type_struct,
    print_for_type_enum,
    print_for_type_string_tmpl,
    print_for_type_int_tmpl,
    print_for_type_choice_tmpl,
    print_for_type_vector_tmpl,
    print_for_type_vector_tmpl_spec,
    print_for_type_vector_tmpl_inst,
    print_for_enumerator,
    print_for_property,
    print_for_value_expr,
    NULL
};

