/*
 * Configuration description abstract syntax operation that creates
 * the Code-Profile (default of all defaults ;-)
 *
 * tbr@peppercon.de
 * (c) 2004 Peppercon AG
 */

#include <stdio.h>
#include <stdlib.h>
#include <pp/cd.h>
#include <pp/cfg.h>
#include "cfg_intern.h"

typedef struct {
    pp_mallocator_t* alloc;
    vector_t* scope;
    pp_profile_t* prof;
} codeprof_ctx_t;

static int push_scope(vector_t* scope, pp_cd_quali_cfg_key_t* qkey) {
    unsigned int i, s = vector_size(qkey);
    for (i = 0; i < s; ++i)
	vector_add(scope, vector_get(qkey, i));
    return i;
}
    
static void pop_scope(vector_t* scope, unsigned int count) {
    unsigned int i, s = vector_size(scope);
    assert(count <= s);
    for (i = 1; i <= count; ++i)
	vector_remove(scope, s - i);
    return;
}

static int
codeprof_for_cd (pp_cd_as_cd_t* cd,  pp_cd_as_op_t* op, void* ctx) {
    int ret;
    ret = cd->values->base.execute((pp_cd_as_t*)cd->values, op, ctx);
    return ret;;
}

static int
codeprof_for_section (pp_cd_as_section_t* s, pp_cd_as_op_t* op, void* ctx) {
    return pp_cd_op_list(s->decls, op, ctx);
}

static int
codeprof_for_value_expr(pp_cd_as_value_expr_t* ve, pp_cd_as_op_t* op,
			 void* ctx) {
    codeprof_ctx_t* c = (codeprof_ctx_t*) ctx;
    pp_profile_t* p = c->prof;
    unsigned int cn;
    char *allk, *helpk, *fn_allk, *fn_name;
    
/* TODO: DEBUG ve->qkey is not freed vect from semcheck */
    cn = push_scope(c->scope, ve->qkey);
    allk = pp_cd_qualikey_to_string(NULL, c->scope);

//    printf("**** %s base type %d\n", allk, ve->base.type);
    switch (ve->base.type) {
      case AS_EXPR_INT_LITERAL:
	  pp_profile_set_int(ve->value.intval, p, allk, NULL);
	  break;
      case AS_EXPR_BOOL_LITERAL:
	  pp_profile_set_bool(ve->value.intval, p, allk, NULL);
	  break;
      case AS_EXPR_ENUM_LITERAL:
      case AS_EXPR_STRING_LITERAL:
	  pp_profile_set(ve->value.stringval, p, allk, NULL);
	  break;
      case AS_EXPR_CHOICE_LITERAL:
	  helpk =  pp_cd_qualified_id_create(pp_mallocator_heap(), allk,
					     pp_cfg_choice_select_comp);
	  pp_profile_set(ve->value.choiceval.choice, p, helpk, NULL);
	  free(helpk);
	  pp_cd_op_list(ve->value.choiceval.choicelist, op, ctx);
	  break;
      case AS_EXPR_FKT_DECL:
	  {
	      int len;
	      /*** registers fkt_decls to 
	       *** pp_profile_set(ipv4cfg, p, device.interfaces[0], NULL);
	       *** pp_profile_set(crazyflashlight, p, device.interfaces[1], NULL);
	       ***/
	      fn_name = (ve->value.fktval)->base.name;
	      len = strlen(allk) + strlen(fn_name) + 8;
	      fn_allk = pp_malloc(pp_mallocator_heap(), len);
	      strcpy(fn_allk, "_val_.");
	      helpk = pp_cd_qualikey_to_qualiid(c->scope);
	      strcat(fn_allk, helpk);
	      free(helpk);
	      strcat(fn_allk, ".");
	      strcat(fn_allk, fn_name);
	      pp_profile_set(fn_allk, p, fn_allk, NULL);
	      free(fn_allk);

	      /**
	       * registers fkt_decls to
	       * fkt_dekl[_FKT_NAME_].params[_PARAM_NAME_] = _PARAM_VALUE_
	       * fkt_dekl[_FKT_NAME_].props[_PROP_NAME_] = _PROP_VALUE_
	       **/
    /*
	      const char *params_str = "fkt_decl[%s].params[%s]";
	      int params_str_len = strlen( params_str );
	      const char *props_str = "fkt_decl[%s].props[%s]";
	      int props_str_len = strlen( props_str );
	      int i, helpk_len;
	      pp_cd_as_type_t *param;
	      pp_cd_as_type_alias_t *param_alias;
	      pp_cd_as_property_t *prop;
	      pp_cd_type_list_t *params = (ve->value.fktval)->params;
	      pp_cd_type_list_t *props = (ve->value.fktval)->properties;
	      int params_size = vector_size( params );
	      int props_size = vector_size( props );

	      for( i = 0; i < params_size; i++ ) {
		  param = (pp_cd_as_type_t*)vector_get( params, i );
		  param_alias = (pp_cd_as_type_alias_t*) param;
		  helpk_len = params_str_len + 
			      strlen( (ve->value.fktval)->name ) + 
			      strlen( param->name );
		  helpk = pp_malloc( pp_mallocator_heap(), helpk_len + 2);
		  sprintf( helpk, params_str, 
			   (ve->value.fktval)->name, param->name );
		  char *value;
		  assert( param->base.type == AS_TYPE_BOOL || 
			  param->base.type == AS_TYPE_ALIAS );
		  switch (param->base.type & AS_TYPE) {
		      case AS_TYPE_BOOL:
			  value = "boolean";
			  break;
		      case AS_TYPE_ALIAS:
			  value = param_alias->ref_type_name;
			  break;
		      default:
			  break;
		  }
    //printf("debug: pp_profile_set( %s, p, %s, NULL);\n", value, helpk);
		  free(helpk);
	      }

	      for( i = 0; i < props_size; i++ ) {
		  prop = (pp_cd_as_property_t*)vector_get( props, i );
		  helpk_len = props_str_len + 
			      strlen( (ve->value.fktval)->name ) + 
			      strlen( prop->key );
		  helpk = pp_malloc( pp_mallocator_heap(), helpk_len + 2);
		  sprintf( helpk, props_str, 
			   (ve->value.fktval)->name, prop->key );
		  pp_profile_set( prop->value.text, p, helpk, NULL);
    //printf("debug: pp_profile_set( %s, p, %s, NULL);\n", prop->value.text, helpk);
		  free(helpk);
	      }
    */
	  }
	      break;
      case AS_EXPR_VALUE_LIST:
	  pp_cd_op_list(ve->value.listval, op, ctx);
	  // if int index vector, set size
	  if ((ve->type->base.type & AS_TYPE) == AS_TYPE_VECTOR_TMPL &&
	      (((pp_cd_as_type_vector_tmpl_t*)ve->type)->idx_type
	       & AS_FUND_TYPE) == AS_FUND_TYPE_INT) {
              /* len = allk + deli + vect_size_comp + \0 = allk + 5 */
              int len = strlen(allk) + 5;
	      helpk = pp_malloc(pp_mallocator_heap(), len);
              strcpy(helpk, allk);
              strcat(helpk, PP_CD_COMP_DELI_STR);
              strcat(helpk, pp_cfg_vect_size_comp);
	      pp_profile_set_int(vector_size(ve->value.listval), p, helpk, NULL);
              free(helpk);
	  }
	  break;
      default: assert(0);
    }
    free(allk);
    pop_scope(c->scope, cn);
    return 0;
}
 
static pp_cd_as_op_t cfg_as_op_codeprof = {
    codeprof_for_cd,
    codeprof_for_section,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    codeprof_for_value_expr,
    NULL
};

pp_profile_t*
cfg_create_code_profile(pp_mallocator_t* a, pp_cd_as_cd_t* cd) {
    pp_profile_t* p;
    
    p = pp_profile_create(a, PP_PROFILE_LOCAL_CODE, "code");

    return cfg_load_profile(p, cd);
}

pp_profile_t*
cfg_load_profile(pp_profile_t* p, pp_cd_as_cd_t* cd) {
    codeprof_ctx_t ctx;

    ctx.alloc = p->allocator;
    ctx.scope = vector_new(NULL, 20, NULL);
    ctx.prof = p;

    pp_cd_execute_op((pp_cd_as_t*)cd, &cfg_as_op_codeprof, &ctx);

    vector_delete(ctx.scope);
    return p;
}

