/*
 * cfg internal defines
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#ifndef __CFG_INTERN_H__
#define __CFG_INTERN_H__

#include <pp/cfg.h>
#include <pp/profile.h>
#include <pp/cd.h>

/* cfg force default:
   if set to 1, the existence of the config key value is asserted in devel mode,
   in final mode, the return value is set to CFG_FORCE_DEFAULT_RETVAL instead.
   if set to 0, the return value stays untouched if no config key value could be
   found */
#define CFG_FORCE_DEFAULT_RETVAL     strdup("")

/*
 * cfg api
 */

typedef struct {
    char* name;
    int alt_next;
    int is_vector_idx;
} key_comp_t;

#define __PP_CFG_INTSTR_SIZE__ 12
#define __PP_CFG_DBLSTR_SIZE__ 14
#define CFG_INT_2_STRVAL(s, number)					\
    {									\
	s = alloca(__PP_CFG_INTSTR_SIZE__);				\
	if (s) snprintf(s, __PP_CFG_INTSTR_SIZE__, "%d", number);	\
    }
#define CFG_UINT_2_STRVAL(s, number)					\
    {									\
	s = alloca(__PP_CFG_INTSTR_SIZE__);				\
	if (s) snprintf(s, __PP_CFG_INTSTR_SIZE__, "%u", number);	\
    }
#define CFG_FLOAT_2_STRVAL(s, number)					\
    {									\
	s = alloca(__PP_CFG_DBLSTR_SIZE__);				\
	if (s) snprintf(s, __PP_CFG_DBLSTR_SIZE__, "%g", (double)number); \
    }
#define CFG_BOOL_2_STRVAL(s, boolval)					\
    s = boolval ? pp_cfg_boolean_true : pp_cfg_boolean_false

vector_t* cfg_key_expand(const char* key, va_list ap);

vector_t* cfg_key_duplicate(const vector_t *key_comps);

pp_cfg_chg_kind_t cfg_set_to_prof_core(const char* value, pp_profile_t* prof,
				       const vector_t* key_comps);

pp_cfg_chg_kind_t cfg_set_to_prof_no_notify(const char* value,
					    pp_profile_t* prof,
					    const vector_t* key_comps);

pp_profile_t* cfg_create_code_profile(pp_mallocator_t* a, pp_cd_as_cd_t* cd);

pp_profile_t* cfg_load_profile(pp_profile_t* p, pp_cd_as_cd_t* cd);

int cfg_save_profile(pp_profile_t* prof, pp_cfg_flush_t flush, int lock);

int cfg_get_from_prof_stack(char** value, vector_t* profile_stack,
                            vector_t *key_comps);

int cfg_get_key_comps_no_tx_check(char** value, pp_profile_type_t prof_type, 
				  vector_t *key_comps);

char* cfg_get_qid_from_key_comps(const vector_t *key_comps,
                                 char *qid, int length);

int cfg_remove_from_prof_core(pp_profile_t* prof, 
                              vector_t *key_comps, int last_comp_idx);

/*
 * cfg notification api
 */
typedef enum {
    KEY_COMPS,
    CFGL_KEYS_HASH,
} cfgl_key_type_t;

typedef struct {
    cfgl_key_type_t     type;
    void*               value;
} cfgl_keys_t;

typedef enum {
    CFGL_TYPE_ANY       = 0xf,
    CFGL_TYPE_WITHIN_TX = 0x1,
    CFGL_TYPE_POST_TX   = 0x2,
} cfgl_listener_type_t;

typedef struct {
    pp_cfg_chg_cb cfg_chg_cb;
    int uid;
    cfgl_listener_type_t type;
    cfgl_keys_t keys;
} cfgl_listener_t;

typedef struct {
    struct list_head hook;
    pthread_t thrid;
    vector_t* listeners;
    cfgl_keys_t*        cfgl_keys;
    pp_cfg_chg_kind_t kind;
    unsigned int lidx;
    pthread_mutex_t mtx;
    pthread_cond_t  cond;
    int                 retval;
    char**              retstr;
    int                 threaded;
    pp_cfg_tx_t*        tx;
    cfgl_listener_type_t type;
} cfg_notify_thr_t;

extern pthread_mutex_t cfg_listeners_mtx;

void cfg_notify_init(void);

void cfg_notify_cleanup(void);

void cfg_fire_change(const vector_t* key_comps, pp_cfg_chg_kind_t kind);

vector_t* cfg_lookup_change_listeners(const vector_t* key_comps);

void cfg_unify_change_listeners(vector_t* listeners, cfgl_keys_t *cfgl_keys);

int cfg_notify_change_listeners(pp_cfg_tx_t* tx, vector_t* listeners,
                                pp_cfg_chg_kind_t kind, cfgl_keys_t* cfgl_keys,
                                cfg_notify_thr_t** nthr, 
                                cfgl_listener_type_t type);

#ifndef PP_BOARD_PEMX
void* cfg_notify_thr_func(void* arg);
#endif

/*
 * cfg transaction api
 */
   
struct pp_cfg_tx_s {
    vector_t*       chg_log;
    pthread_mutex_t mtx;
    int             commit_in_progress;
};

typedef struct cfg_tx_log_entry_s cfg_tx_log_entry_t;

void cfg_tx_set_va(pp_cfg_tx_t* tx, const char* value,
		   pp_profile_type_t type, const char* key, va_list ap);

void cfg_tx_set_key_comps(pp_cfg_tx_t* tx, const char* value,
			  pp_profile_type_t type, vector_t* key_comps);

void cfg_tx_remove_va(pp_cfg_tx_t* tx, pp_profile_type_t type,
	    	      const char* key, va_list ap);

int cfg_tx_get_key_comps(pp_cfg_tx_t* tx, char **value,
                         pp_profile_type_t type, const vector_t *key_comps);

typedef enum { CFG_TX_OP_SET,
	       CFG_TX_OP_REM
} cfg_tx_op_type_t;

cfg_tx_log_entry_t* cfg_tx_log_entry_create(cfg_tx_op_type_t  op_type,
                                            pp_profile_type_t prof_type,
					    vector_t* key_comps,
					    const char* value);

#ifdef PP_FEAT_IPMI_SERVER
int acl_ipmi_set_perm_by_priv_level_cb(pp_cfg_chg_ctx_t *ctx);
#endif /* PP_FEAT_IPMI_SERVER */

#endif /* __CFG_INTERN_H__ */
