/*
 * dumps a CDL file to a file
 *
 * (c) 2007 Peppercon AG
 * tweb@peppercon.de
 */

#include <stdio.h>
#include <pp/cfg.h>
#include <liberic_config.h>

int main(int argc, char** argv) {
    if(argc < 2 || argc > 3 ||
       (argc && (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help")))) {
        printf("\n"
               "  %s [cdl_file] <file>\n\n"
               "      cdl_file ... cdl_file to dump\n"
               "      file ....... file to dump profile in (optional)\n\n",
               argv[0]);
    } else {
        eric_config_init(FLUSH_IN_BACKGROUND);
        pp_cfg_dump_profile(argv[1], argc == 3 ? argv[2] : "/dev/stdout");
        eric_config_cleanup();
    }
    return 0;
}
