#ifndef _PP_CIM_INSTANCE_H
#define _PP_CIM_INSTANCE_H

#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"

// CIM class/instance template structure
typedef struct {
    // CIM class name
    const char *cim_name;
    // user friendly class tag
    const char *ufct;
    // display name (e.g. for WS-Management)
    const char *dispname;
    // superclass name
    const char *superclass;
    // associaion class
    int assoc;
    // property declarations; terminate with name == NULL
    pp_cim_property_t *properties;
    // method declarations; terminate with name == NULL
    pp_cim_method_t *methods;
    // optional: find new instances of this class
    void (*update)(pp_cim_class_t *cim_class);
    // optional: find new CLP children
    void (*clp_update)(pp_cim_class_t *cim_class);
    // optional: get CLP help message for class
    char *(*clp_help)(pp_cim_class_t *cim_class, int verbose);
} pp_cim_class_desc_t;

// Create a new CIM instance
pp_cim_instance_t *pp_cim_instance_new(const char *cim_class,
	pp_cim_provider_t *provider);
// Delete a CIM instance from memory.
void pp_cim_instance_free(pp_cim_instance_t *instance);
void pp_cim_instance_remove_from_list(pp_cim_instance_t *instance);

#ifdef PP_CIM_DEBUG
void pp_cim_instance_dump(pp_cim_instance_t *instance);
#endif

// Duplicate a property/value structure
pp_cim_propval_t *pp_cim_propval_dup(pp_cim_propval_t *propval);
// Duplicate a method structure
pp_cim_method_t *pp_cim_method_dup(pp_cim_method_t *method);

#endif // _PP_CIM_INSTANCE_H

