#ifndef _PP_CIM_NAMESPACE_H
#define _PP_CIM_NAMESPACE_H

#include <pp/cim.h>
#include <pp/cimTypes.h>
#include "instance.h"

// CIM instance repository
extern pp_hash_t *pp_cim_repository;
// CIM instance repository (UFcT-indexed)
extern pp_hash_t *pp_cim_repository_ufct;
// CIM instance repository lock
extern pthread_rwlock_t pp_cim_repository_lock;

// CIM (CLP actually) namespace root
extern pp_cim_instance_t *namespace_root;

// CIM/CLP namespace initialization
void pp_cim_ns_init(void);
// Namespace deinitialization
void pp_cim_ns_deinit(void);
// Convert string to lower case
char *strdup_lc(const char *string);
// Add one instance to another one's children
void pp_cim_add_instance(pp_cim_instance_t *instance, pp_cim_instance_t *parent);

#endif // _PP_CIM_NAMESPACE_H

