#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_authorizedprivilege.h"

// class description
pp_cim_class_desc_t pp_cim_authorizedprivilege_desc =
{
    .cim_name = "CIM_AuthorizedPrivilege",
    .ufct = "authorizedpriv",
    .dispname = "CIM Authorized Privilege",
    .superclass = "CIM_Privilege",
    .assoc = 0,
    .properties = NULL, // no properties
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_AuthorizedPrivilege instance
pp_cim_instance_t *pp_cim_authorizedprivilege_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_AuthorizedPrivilege", &provider_common);
    pp_cim_data_t d1;
    pp_cim_data_t *d2;
    d1.null = 0;
    d1.types.string_const = "IPMI Privilege";
    provider_common_set_property(i, "InstanceID", d1, 1);
    d1.types.array = vector_new(NULL, 1, NULL);
    d2 = malloc(sizeof(pp_cim_data_t));
    d2->null = 0;
    d2->types.unsigned_int = 7; // Execute
    vector_add(d1.types.array, d2);
    provider_common_set_property(i, "Activities", d1, 1);
    free(d2);
    vector_delete(d1.types.array);
    return i;
}

