#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_authorizedsubject.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Privilege", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"PrivilegedElement", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_authorizedsubject_desc =
{
    .cim_name = "CIM_AuthorizedSubject",
    .ufct = NULL,
    .dispname = "CIM Authorized Subject",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_AuthorizedSubject instance
pp_cim_instance_t *pp_cim_authorizedsubject_new(
    pp_cim_instance_t *privilege, pp_cim_instance_t *subject)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_AuthorizedSubject", &provider_common);
    d.null = privilege ? 0 : 1;
    d.types.reference = privilege;
    provider_common_set_property(i, "Privilege", d, 1);
    d.null = subject ? 0 : 1;
    d.types.reference = subject;
    provider_common_set_property(i, "PrivilegedElement", d, 1);
    return i;
}

