#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_authorizedtarget.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Privilege", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"TargetElement", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_authorizedtarget_desc =
{
    .cim_name = "CIM_AuthorizedTarget",
    .ufct = NULL,
    .dispname = "CIM Authorized Target",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_AuthorizedTarget instance
pp_cim_instance_t *pp_cim_authorizedtarget_new(
    pp_cim_instance_t *privilege, pp_cim_instance_t *target)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_AuthorizedTarget", &provider_common);
    d.null = privilege ? 0 : 1;
    d.types.reference = privilege;
    provider_common_set_property(i, "Privilege", d, 1);
    d.null = target ? 0 : 1;
    d.types.reference = target;
    provider_common_set_property(i, "TargetElement", d, 1);
    return i;
}

