#ifndef _PP_CIM_PROVIDER_COMMON_H
#define _PP_CIM_PROVIDER_COMMON_H

#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>

// all generic provider structure
extern pp_cim_provider_t provider_common;

// generic provider methods
void provider_common_deinit(pp_cim_instance_t *instance);
void provider_common_update(pp_cim_instance_t *instance);
void provider_common_commit(pp_cim_instance_t *instance);
int provider_common_authorize(pp_cim_instance_t *instance, 
    const char *auth_string);
pp_cim_propval_t *provider_common_get_property(pp_cim_instance_t *instance,
	const char *name);
int provider_common_set_property(pp_cim_instance_t *instance,
	const char *name, pp_cim_data_t data, int force);
vector_t *provider_common_list_properties(pp_cim_instance_t *instance);
vector_t *provider_common_get_properties(pp_cim_instance_t *instance);
int provider_common_set_properties(pp_cim_instance_t *instance,
	vector_t *names, vector_t *props);
pp_cim_methodptr_t *provider_common_get_method(pp_cim_instance_t *instance,
	const char *name);
int provider_common_call_method(pp_cim_instance_t *instance,
	const char *name, vector_t *args, pp_cim_data_t *result);

#endif // _PP_CIM_PROVIDER_COMMON_H

