#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_elementcapabilities.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"ManagedElement", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"Capabilities", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_elementcapabilities_desc =
{
    .cim_name = "CIM_ElementCapabilities",
    .ufct = NULL,
    .dispname = "CIM Element Capabilities",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_ElementCapabilities instance
pp_cim_instance_t *pp_cim_elementcapabilities_new(
    pp_cim_instance_t *element, pp_cim_instance_t *capabilities)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_ElementCapabilities", &provider_common);
    d.null = element ? 0 : 1;
    d.types.reference = element;
    provider_common_set_property(i, "ManagedElement", d, 1);
    d.null = capabilities ? 0 : 1;
    d.types.reference = capabilities;
    provider_common_set_property(i, "Capabilities", d, 1);
    return i;
}

