#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_elementconformstoprofile.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"ConformantStandard", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"ManagedElement", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_elementconformstoprofile_desc =
{
    .cim_name = "CIM_ElementConformsToProfile",
    .ufct = NULL,
    .dispname = "CIM Element Conforms To Profile",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_ElementConformsToProfile instance
pp_cim_instance_t *pp_cim_elementconformstoprofile_new(
    pp_cim_instance_t *standard, pp_cim_instance_t *element)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_ElementConformsToProfile", &provider_common);
    d.null = standard ? 0 : 1;
    d.types.reference = standard;
    provider_common_set_property(i, "ConformantStandard", d, 1);
    d.null = element ? 0 : 1;
    d.types.reference = element;
    provider_common_set_property(i, "ManagedElement", d, 1);
    return i;
}

