#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_registeredprofile.h"
#include "provider_common.h"
#include "valmap_registeredprofile.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"InstanceID", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {0, {.string_const = "IPMI : Mapping"}}},
    {"RegisteredOrganization", PP_CIM_UNSIGNED, 0, registeredorganization_valmap, 0, 0, 1, 0, {0, {.unsigned_int = 1 /* Other */}}},
    {"OtherRegisteredOrganization", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 1, 0, {0, {.string_const = "IPMI Forum"}}},
    {"RegisteredName", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 1, 0, {0, {.string_const = "IPMI CIM Mapping Guideline"}}},
    {"RegisteredVersion", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 1, 0, {0, {.string_const = "Version 0.50"}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_registeredprofile_desc =
{
    .cim_name = "CIM_RegisteredProfile",
    .ufct = "profile",
    .dispname = "CIM Registered Profile",
    .superclass = "CIM_ManagedElement",
    .assoc = 0,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_RegisteredProfile instance
pp_cim_instance_t *pp_cim_registeredprofile_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_RegisteredProfile", &provider_common);
    return i;
}

