#include "clp_common.h"
#include "clpParser.h"
#include "command.h"
#include <pp/cim.h>
#include <pp/clp.h>
#include <liberic_term.h>

static int clp_initialized = 0;

static int pp_clp_service(pp_clp_session_t *session, char *buf);
static int pp_clp_init(void);

pp_clp_session_t *pp_clp_open(term_cl_t *term)
{
	pp_clp_session_t *session;

	if (!clp_initialized)
		pp_clp_init();

	session = malloc(sizeof(pp_clp_session_t));
	session->term = term;
	vector_new(&session->default_target, 5,
		(vector_elem_del_func_simple)pp_clp_ufit_delete);
	session->prompt = strdup("clp:/-> ");

	session->cont = 0;
	return session;
}

void pp_clp_close(pp_clp_session_t *session)
{
	if (!session)
		return;
	if (session->cont)
		vector_delete(&session->tokens);
	vector_delete(&session->default_target);
	free(session->prompt);
	free(session);
}

static int pp_clp_service(pp_clp_session_t *session, char *buf)
{
	int ret = PP_ERR;
	pp_clp_cmd_t *cmd;

	if (!session->cont) {
		vector_new(&session->tokens, 20, free);
		session->tok_state = PP_CLP_TOK_NORMAL;
	}

	assert(NULL != buf);
	puts(buf);

	/* tokenizing */
	if (PP_FAILED(clp_parser_tokenizer(session, buf, &session->tokens))) {
		pp_clp_debug("Tokenizer failed.\n");
		goto bail;
	}

	if (!session->cont && vector_size(&session->tokens) > 0) {
		/* get the command */
		cmd = clp_token_check(session, &session->tokens);

		if (!cmd)
			goto bail;

#ifdef PP_CLP_DEBUG
		pp_clp_cmd_dump(cmd);
#endif

		if (!clp_verb_handler[cmd->verb]) {
			eric_term_printf(session->term, "No verb handler.\r\n");
			ret = PP_ERR;
		} else {
			ret = clp_verb_handler[cmd->verb](session, cmd);
		}

		pp_clp_cmd_delete(cmd);
	}

bail:
	if (!session->cont)
		vector_delete(&session->tokens);
	return ret;
}


/* the entry point of clp service, called by liberic_term */

int pp_clp_invoke(pp_clp_session_t *session, char *cmd_buf)
{
	assert(NULL != cmd_buf);
	assert(NULL != session);

	/* cmd will be copied to CLP */
	return pp_clp_service(session, cmd_buf);
}

static int pp_clp_init()
{
	/* verb-option-value matrix */
	clp_matrix_init();
	clp_initialized = 1;
	return PP_SUC;
}

