#ifndef CLP_COMMAND_H
#define CLP_COMMAND_H

#include <pp/clp.h>
#include <liberic_term.h>

#define VERSION "0.1"

/* command handler function */
typedef int (*clp_verb_handler_t)(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
extern clp_verb_handler_t clp_verb_handler[];

int clp_verb_handler_cd(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_exit(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_help(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_reset(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_set(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_show(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_start(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_stop(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_version(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_create(pp_clp_session_t *session, pp_clp_cmd_t *cmd);
int clp_verb_handler_delete(pp_clp_session_t *session, pp_clp_cmd_t *cmd);

void clp_help_verb(term_cl_t *term, pp_clp_verb_t verb, int verbose);

#endif

