#include "clpParser.h"
#include "clp_common.h"
#include "command.h"
#include <pp/cim.h>

int clp_verb_handler_create(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	vector_t *instances = NULL;
	vector_t *calls = NULL;
	pp_cim_class_t *cim_class = NULL;
	pp_cim_instance_t *instance; // the target or the parent of the target
	pp_cim_method_t *method;
	int instance_id = -1;
	pp_cim_data_t result;
	int ret = PP_ERR;
	int org_target_type;

	//printf("%s\n", __FUNCTION__);
	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_CREATE, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "CREATE %s\r\n", VERSION);
		return PP_SUC;
	}

	org_target_type = cmd->target->type;

	// should be process different type of target
	if (cmd->target->type == CLP_TARGET_INSTANCE) {
		// get class name from last ufip (the same as clpParser)
		unsigned int last = vector_size(cmd->target->ufip1) - 1;
		pp_clp_ufit_t *ufit = vector_get(cmd->target->ufip1, last);
		cmd->target->ufct = strdup(ufit->ufct);
		instance_id = ufit->instance_id;
		vector_remove(cmd->target->ufip1, last);

		// add instance id into properties
		printf("ID to be created: %d\n", instance_id);
		char buff[10];
		sprintf(buff, "%d", instance_id);
		pp_clp_property_value_t *prop;
		prop = pp_clp_propval_new();
		prop->property = strdup("instance_id");
		prop->value = strdup(buff);
		vector_add(&cmd->properties, prop);

	} else { // CLP_TARGET_CLASS || CLP_TARGET_SET || CLP_TARGET_ASSOCIATION
		// the target is the parent device, so change the type of the target to
		// lookup the instance of the parent device
		cmd->target->type = CLP_TARGET_INSTANCE;
	}

	// lookup the instance (depend on the type of the target)
	instances = pp_cim_clp_lookup(cmd->target, &session->default_target);
	if (!instances || vector_size(instances) == 0) {
		eric_term_printf(session->term, "Target not found.\r\n");
		goto bail;
	} else if (vector_size(instances) > 1) {
		eric_term_printf(session->term, "Ambiguous target address.\r\n");
		goto bail;
	}
	instance = vector_get(instances, 0);
	//pp_cim_instance_dump(instance);

	//printf("create %s id %d\n", cmd->target->ufct, instance_id); // debug only

	// find the class, and lock it
	cim_class = pp_cim_class_lookup_ufct(cmd->target->ufct);
	if (cim_class == NULL) {
		eric_term_printf(session->term, "Invalid Target\r\n");
		goto bail;
	}

	// check and find the create method
	method = pp_cim_clp_create_supported(cim_class);
	if (!method) {
		eric_term_printf(session->term, "Target does not support Create command.\r\n");
		goto bail;
	}

	// execute the create method
	method->defptr(instance, &cmd->properties, &result);
	if (result.null || result.types.reference == 0) {
		eric_term_printf(session->term, "Create Error\r\n");
		goto bail;
	} else {
		if (org_target_type == CLP_TARGET_ASSOCIATION) {
			// the result is different for the CLP_TARGET_ASSOCIATION
			// print the target first
			vector_t *ufip = vector_new(NULL, 10,
				(vector_elem_del_func_simple)pp_clp_ufit_delete);
			if (PP_SUCCED(pp_cim_get_ufip(instance, ufip))) {
				char *path = pp_clp_print_ufip(ufip, 0);
				eric_term_printf(session->term, "%s=>", path);
				free(path);
			}
			vector_delete(ufip);

			// print the class name
			eric_term_printf(session->term, "%s=>", cmd->target->ufct);

			// then the same as other case
		}
		vector_t *ufip = vector_new(NULL, 10,
			(vector_elem_del_func_simple)pp_clp_ufit_delete);
		if (PP_SUCCED(pp_cim_get_ufip(result.types.reference, ufip))) {
			char *path = pp_clp_print_ufip(ufip, 0);
			eric_term_printf(session->term, "%s\r\n", path);
			free(path);
		}
		vector_delete(ufip);
	}

bail:
	if (calls)
		vector_delete(calls);
	if (instances)
		vector_delete(instances);
	if (cim_class)
		pp_cim_class_release(cim_class);
	return ret;
}

