#include "clpParser.h"
#include "clp_common.h"
#include "command.h"
#include <pp/cim.h>

int clp_verb_handler_delete(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	unsigned int i;
	vector_t *instances = NULL;
	vector_t *calls = NULL;
	pp_cim_instance_t *instance;
	pp_cim_data_t result;
	int ret = PP_ERR;
	int delete_count = 0;
	char name[128];
	int id;

	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_DELETE, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "DELETE %s\r\n", VERSION);
		return PP_SUC;
	}

	instances = pp_cim_clp_lookup(cmd->target, &session->default_target);
	if (!instances || vector_size(instances) == 0) {
		eric_term_printf(session->term, "Target not found.\r\n");
		goto bail;
	}

	for (i = 0; i < vector_size(instances); i++) {
		instance = vector_get(instances, i);

		//pp_cim_instance_dump(instance);
		if (!pp_cim_clp_delete_supported(instance)) {
			eric_term_printf(session->term, "Target does not support Delete command.\r\n");
			goto bail;
		}

		if (cmd->target->type == CLP_TARGET_ASSOCIATION) {
			char *s1, *s2;
			s1 = pp_clp_print_ufip(cmd->target->ufip1, cmd->target->ufip1_relative);
			s2 = pp_clp_print_ufip(cmd->target->ufip2, cmd->target->ufip2_relative);
			strcpy(name, s1);
			strcat(name, "=>");
			strcat(name, cmd->target->ufct);
			strcat(name, "=>");
			strcat(name, s2);
			free(s1);
			free(s2);
		} else {
			strcpy(name, instance->cim_class->ufct);
		}
		id = instance->instance_id;

		pp_cim_methodptr_t *method = pp_cim_clp_map_delete(instance);
		if (PP_SUCCED(method->ptr(instance, NULL, &result))) {

			if (cmd->target->type == CLP_TARGET_ASSOCIATION) {
				eric_term_printf(session->term, "%s deleted.\r\n", name);
			} else {
				eric_term_printf(session->term, "%s%d deleted.\r\n", name, id);
			}
			delete_count++;
		}
	}

	if (delete_count == 0) {
		eric_term_printf(session->term, "No targets deleted.\r\n");
	} else if (delete_count > 1) {
		eric_term_printf(session->term, "%d %ss successfuly deleted.\r\n", delete_count, name);
	}
	ret = PP_SUC;

bail:
	if (calls)
		vector_delete(calls);
	if (instances)
		vector_delete(instances);

	return ret;
}

