#include "clpParser.h"
#include "clp_common.h"
#include "command.h"
#include <pp/cim.h>

int clp_verb_handler_reset(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	vector_t *instances = NULL;
	pp_cim_instance_t *instance;
	pp_cim_method_call_t *call;
	int ret = PP_ERR;

	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_RESET, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "RESET %s\r\n", VERSION);
		return PP_SUC;
	}

	instances = pp_cim_clp_lookup(cmd->target, &session->default_target);
	if (!instances || vector_size(instances) != 1) {
		eric_term_printf(session->term, "Target not found.\r\n");
		goto bail;
	}
	instance = vector_get(instances, 0);

	// perform CLP-CIM mapping
	if (!pp_cim_clp_reset_supported(instance)) {
		eric_term_printf(session->term, "Target does not support Reset command.\r\n");
		goto bail;
	}

	call = pp_cim_clp_map_reset(instance);
	if (!call) {
		eric_term_printf(session->term, "CIM mapping failure.\r\n");
		goto bail;
	}

	// execute method call
	if (cmd->opt_examine) {
		eric_term_printf(session->term, "Command validity check successful.\r\n");
		eric_term_printf(session->term, "Run without -examine option to perform command.\r\n");
	} else {
		pp_cim_method_call_exec(call, NULL);
	}
	pp_cim_method_call_delete(call);
	ret = PP_SUC;

bail:
	if (instances)
		vector_delete(instances);
	return ret;
}

