#include "clpParser.h"
#include "clp_common.h"
#include "command.h"
#include <pp/cim.h>

int clp_verb_handler_set(pp_clp_session_t *session, pp_clp_cmd_t *cmd)
{
	unsigned int i;
	vector_t *instances = NULL;
	vector_t *calls = NULL;
	pp_cim_instance_t *instance;
	int ret = PP_ERR;

	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_SET, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "SET %s\r\n", VERSION);
		return PP_SUC;
	}

	instances = pp_cim_clp_lookup(cmd->target, &session->default_target);
	if (!instances || vector_size(instances) == 0) {
		eric_term_printf(session->term, "Target not found.\r\n");
		goto bail;
	} else if (vector_size(instances) > 1) {
		eric_term_printf(session->term, "Ambiguous target address.\r\n");
		goto bail;
	}
	instance = vector_get(instances, 0);

	if (!pp_cim_clp_set_supported(instance)) {
		eric_term_printf(session->term, "Target does not support Set command.\r\n");
		goto bail;
	}

	if (vector_size(&cmd->properties) == 0) {
		eric_term_printf(session->term, "One or more property=value pairs expected.\r\n");
		goto bail;
	}

	calls = vector_new(NULL, vector_size(&cmd->properties),
		(vector_elem_del_func_simple)pp_cim_method_call_delete);

	// perform CLP-CIM mapping
	for (i = 0; i < vector_size(&cmd->properties); i++) {
		pp_clp_property_value_t *pv = vector_get(&cmd->properties, i);
		pp_cim_propval_t *p = pp_cim_get_property(instance, pv->property);
		pp_cim_datatype_t type;
		pp_cim_method_call_t *call;

		if (!p) {
			eric_term_printf(session->term, "Property not found: %s.\r\n", pv->property);
			goto bail;
		}
		type = p->property->type;
		pp_cim_propval_delete(p);
		if (type == PP_CIM_REFERENCE) {
			pp_cim_instance_t *ref = NULL;
			int is_rel, is_inst;
			vector_t *ufip = vector_new(NULL, 10,
				(vector_elem_del_func_simple)pp_clp_ufit_delete);
			pp_strstream_t *str;

			if (PP_SUCCED(parse_ufip(pv->value, ufip, &is_rel, &is_inst, NULL))) {
				if (is_rel) {
					ref = pp_cim_lookup_absolute(&session->default_target);
					if (ref) {
						ref = pp_cim_lookup_relative(ref, ufip);
					}
				} else {
					ref = pp_cim_lookup_absolute(ufip);
				}
			}
			vector_delete(ufip);
			if (!ref) {
				eric_term_printf(session->term, "Instance not found: %s.\r\n", pv->value);
				goto bail;
			}

			// Ugly hack: The instance pointer is stored as a string in
			//            pp_clp_property_value_t.value.
			str = pp_strstream_init(NULL);
			pp_strappendf(str, "%p", ref);
			free(pv->value);
			pv->value = pp_strstream_buf_and_free(str);
		}

		call = pp_cim_clp_map_set(instance, pv);
		if (!call) {
			eric_term_printf(session->term, "CIM mapping failure for property %s.\r\n", pv->property);
			goto bail;
		}
		vector_add(calls, call);
	}

	// execute method calls
	if (cmd->opt_examine) {
		eric_term_printf(session->term, "Command validity check successful.\r\n");
		eric_term_printf(session->term, "Run without -examine option to perform command.\r\n");
	} else {
		for (i = 0; i < vector_size(calls); i++) {
			pp_cim_method_call_exec(vector_get(calls, i), NULL);
		}
	}
	ret = PP_SUC;

bail:
	if (calls)
		vector_delete(calls);
	if (instances)
		vector_delete(instances);
	return ret;
}

