#include "clpParser.h"
#include "command.h"

int clp_verb_handler_version(pp_clp_session_t *session,
	pp_clp_cmd_t *cmd UNUSED)
{
	if (cmd->opt_help) {
		int verbose = (cmd->output.level == CLP_OUTPUT_VERBOSE);
		clp_help_verb(session->term, CLP_VERB_VERSION, verbose);
		return PP_SUC;
	} else if (cmd->opt_version) {
		eric_term_printf(session->term, "VERSION %s\r\n", VERSION);
		return PP_SUC;
	} else if (cmd->opt_examine) {
		eric_term_printf(session->term, "Command validity check successful.\r\n");
		eric_term_printf(session->term, "Run without -examine option to perform command.\r\n");
	} else {
		eric_term_printf(session->term, "CLP protocol revision: Version 1.0a\r\n");
	}
	return PP_SUC;
}

