#include "disconf_intern.h"

#include <assert.h>

/***************************************************************
 * CNode
 ***************************************************************/

pp_dc_cnode_t*
pp_dc_cnode_new()
{
    pp_dc_cnode_t *node;
    node=(pp_dc_cnode_t*)malloc(sizeof(pp_dc_cnode_t));
    node->tag=0;
    node->un.gen=NULL;
    node->next=NULL;
    return node;
}

pp_dc_cnode_t*
pp_dc_cnode_create(pp_dc_tag_t tag,void* data)
{
    pp_dc_cnode_t *node=pp_dc_cnode_new();
    node->tag=tag;
    node->un.gen=data;
	node->next=NULL;
    return node;
}

#if 0
void
pp_dc_cnode_append(pp_dc_cnode_t *root,pp_dc_cnode_t *node)
{
    pp_dc_cnode_t *iter=root;
    while(iter->next!=NULL) iter=iter->next;
    iter->next=node;
}
#endif

void
pp_dc_cnode_free(pp_dc_cnode_t *node)
{
    if(node==NULL)
	return;

    switch(node->tag){
    case PP_DC_TAG_PLAIN:
	pp_dc_plain_free(node->un.plain);
	break;
    case PP_DC_TAG_COMPRESSED:
	pp_dc_compressed_free(node->un.compressed);
	break;
    case PP_DC_TAG_ESK:
	pp_dc_esk_free(node->un.esk);
	break;
    case PP_DC_TAG_SIGNATURE:
	pp_dc_signature_free(node->un.signature);
	break;
    case PP_DC_TAG_ENCRYPTED:
	pp_dc_encrypted_free(node->un.encrypted);
	break;
    case PP_DC_TAG_HASH:
	break;
    case PP_DC_TAG_SKEY:
	pp_dc_skey_free(node->un.skey);
	break;
    case PP_DC_TAG_PUBKEY:
	pp_dc_pubkey_free(node->un.pubkey);
	break;
    case PP_DC_TAG_PRIVKEY:
	pp_dc_privkey_free(node->un.privkey);
	break;    
    case PP_DC_TAG_NULL:
	break;
    }

    pp_dc_cnode_free(node->next);

    free(node);
}

void
pp_dc_cnode_print(pp_dc_cnode_t *node)
{
    if(node==NULL)
	return;
    switch(node->tag) {
    case PP_DC_TAG_COMPRESSED:
	printf("compressed(\n");
	pp_dc_cnode_print(node->un.compressed->sub);
	printf(")\n");
	break;
    case PP_DC_TAG_PLAIN:
	printf("plain(%d)\n",node->un.plain->size);
	break;
    case PP_DC_TAG_SIGNATURE:
	printf("signature(hash=%d,pub=%d)\n",
	       node->un.signature->hash_algo,
	       node->un.signature->pub_algo);
	break;
    case PP_DC_TAG_ESK:
	printf("esk\n");
	break;
    case PP_DC_TAG_ENCRYPTED:
	printf("encrypted(\n");
	pp_dc_cnode_print(node->un.encrypted->sub);
	printf(")\n");
    default:;
    }
    pp_dc_cnode_print(node->next);
}

int
pp_dc_cnode_parse(BIO* bio,pp_dc_cnode_t **node)
{
    int ret=0;
    u_int8_t tag;
    u_int16_t size;

    if(!read_uint8(bio,&tag))
	return 1;
    if(!read_uint16(bio,&size))
	return 0;

    *node=pp_dc_cnode_new();
    (*node)->tag=tag;

    switch(tag) {
    case PP_DC_TAG_PLAIN:
	ret=pp_dc_plain_parse(bio,&(*node)->un.plain,size);
	break;
    case PP_DC_TAG_COMPRESSED:
	ret=pp_dc_compressed_parse(bio,&(*node)->un.compressed,size);
	break;
    case PP_DC_TAG_ESK:
	ret=pp_dc_esk_parse(bio,&(*node)->un.esk,size);
	break;
    case PP_DC_TAG_SIGNATURE:
	ret=pp_dc_signature_parse(bio,&(*node)->un.signature,size);
	break;
    case PP_DC_TAG_ENCRYPTED:
	ret=pp_dc_encrypted_parse(bio,&(*node)->un.encrypted,size);
	break;
    case PP_DC_TAG_HASH:
	break;
    case PP_DC_TAG_SKEY:
	ret=pp_dc_skey_parse(bio,&(*node)->un.skey,size);
	break;
    case PP_DC_TAG_PUBKEY:
	ret=pp_dc_pubkey_parse(bio,&(*node)->un.pubkey,size);
	break;
    case PP_DC_TAG_PRIVKEY:
	ret=pp_dc_privkey_parse(bio,&(*node)->un.privkey,size);
	break;
    default:
	assert(1);
    }
    if(ret)
	return pp_dc_cnode_parse(bio,&(*node)->next);
    else {
	free(*node);
	*node=NULL;
	return 0;
    }
}

int
pp_dc_cnode_parse_mem(char* data,size_t size,pp_dc_cnode_t **node)
{
    BIO *bio=BIO_new_mem_buf(data,size);
    int ret=pp_dc_cnode_parse(bio,node);
    BIO_free(bio);
    return ret;
}

int
pp_dc_cnode_build(BIO *bio,pp_dc_cnode_t *node)
{
    int ret=0;
    BIO *membio;
    char *data;
    size_t size;

    if(node==NULL)
	return 1;

    membio=BIO_new(BIO_s_mem());

    switch(node->tag) {
    case PP_DC_TAG_PLAIN:
	ret=pp_dc_plain_build(membio,node->un.plain);
	break;
    case PP_DC_TAG_COMPRESSED:
	ret=pp_dc_compressed_build(membio,node->un.compressed);
	break;
    case PP_DC_TAG_ESK:
	ret=pp_dc_esk_build(membio,node->un.esk);
	break;
    case PP_DC_TAG_SIGNATURE:
	ret=pp_dc_signature_build(membio,node->un.signature);
	break;
    case PP_DC_TAG_ENCRYPTED:
	ret=pp_dc_encrypted_build(membio,node->un.encrypted);
	break;
    case PP_DC_TAG_HASH:
	break;
    case PP_DC_TAG_SKEY:
	ret=pp_dc_skey_build(membio,node->un.skey);
	break;
    case PP_DC_TAG_PUBKEY:
	ret=pp_dc_pubkey_build(membio,node->un.pubkey);
	break;
    case PP_DC_TAG_PRIVKEY:
	ret=pp_dc_privkey_build(membio,node->un.privkey);
	break;
    case PP_DC_TAG_NULL:
	ret=0;
	break;
    default:
	assert(1);
    }


    if(ret) {
	size=BIO_get_mem_data(membio,&data);
	write_node(bio,node->tag,data,size);
	BIO_free(membio);
	return pp_dc_cnode_build(bio,node->next);
    } else {
	BIO_free(membio);
	return 0;
    }
}

int
pp_dc_cnode_build_mem(char *buf,size_t *size,pp_dc_cnode_t *node)
{
    BIO *bio=BIO_new(BIO_s_mem());
    char *temp;

    pp_dc_cnode_build(bio,node);

    if(*size<BIO_ctrl_pending(bio)) {
	BIO_free(bio);
	return 0;
    }

    *size=BIO_get_mem_data(bio,&temp);

    memcpy(buf,temp,*size);

    BIO_free(bio);
    return 1;
}

size_t
pp_dc_cnode_getdata(pp_dc_cnode_t *node,char **data)
{
    if(node==NULL)
	return 0;
    switch(node->tag) {
    case PP_DC_TAG_PLAIN:
	*data=(char*)node->un.plain->data;
	return node->un.plain->size;
    case PP_DC_TAG_COMPRESSED:
	return pp_dc_cnode_getdata(node->un.compressed->sub,data);
    case PP_DC_TAG_SIGNATURE:
	return pp_dc_cnode_getdata(node->next,data);
    case PP_DC_TAG_ENCRYPTED:
	return pp_dc_cnode_getdata(node->un.encrypted->sub,data);
    case PP_DC_TAG_ESK:
	return pp_dc_cnode_getdata(node->next,data);
    default:
	return 0;
    }
}
