#include "disconf_intern.h"

#include <zlib.h>

/***************************************************************
 * Compressed
 ***************************************************************/

pp_dc_compressed_t*
pp_dc_compressed_new()
{
    pp_dc_compressed_t *ret=(pp_dc_compressed_t*)malloc(sizeof(pp_dc_compressed_t));

    ret->sub=NULL;

    return ret;
}

void
pp_dc_compressed_free(pp_dc_compressed_t *compressed)
{
    pp_dc_cnode_free(compressed->sub);
    free(compressed);
}

pp_dc_cnode_t*
pp_dc_compressed2cnode(pp_dc_compressed_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_COMPRESSED,x);
}

pp_dc_compressed_t*
pp_dc_cnode2compressed(pp_dc_cnode_t *x)
{
    if(x && x->tag==PP_DC_TAG_COMPRESSED)
	return x->un.compressed;
    else
	return NULL;
}

int
pp_dc_compressed_parse(BIO* bio,pp_dc_compressed_t **compressed,size_t size)
{
    char temp[2048],*data;
    unsigned long tempsize=2048;
    int ret;

    *compressed=pp_dc_compressed_new();

    read_data(bio,&data,size);

    if(uncompress(temp,&tempsize,data,size)!=Z_OK)
	return 0;
    ret=pp_dc_cnode_parse_mem((char*)temp,tempsize,&(*compressed)->sub);
    free(data);
    return ret;
}

int
pp_dc_compressed_build(BIO *bio,pp_dc_compressed_t *compressed)
{
    unsigned char temp[2048],in[2048];
    unsigned long size=2048;
    size_t insize=2048;

    pp_dc_cnode_build_mem((char*)in,&insize,compressed->sub);

    if(compress(temp,&size,in,insize)!=Z_OK) {
	return 0;
    }

    return write_data(bio,(char*)temp,size);
}

pp_dc_compressed_t*
pp_dc_compressed_gen(pp_dc_cnode_t *node)
{
    pp_dc_compressed_t *ret=pp_dc_compressed_new();
    ret->sub=node;
    return ret;
}
