#include "disconf_intern.h"

/***************************************************************
 * Encrypted
 ***************************************************************/

pp_dc_encrypted_t*
pp_dc_encrypted_new()
{
    pp_dc_encrypted_t *ret=(pp_dc_encrypted_t*)malloc(sizeof(pp_dc_encrypted_t));
    ret->size=0;
    ret->data=NULL;
    ret->sub=NULL;
    ret->skey=NULL;
    return ret;
}

void
pp_dc_encrypted_free(pp_dc_encrypted_t *encrypted)
{
    if(encrypted->sub)
	pp_dc_cnode_free(encrypted->sub);
    if(encrypted->skey)
	pp_dc_skey_free(encrypted->skey);
    free(encrypted->data);
    free(encrypted);
}

pp_dc_cnode_t*
pp_dc_encrypted2cnode(pp_dc_encrypted_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_ENCRYPTED,x);
}

pp_dc_encrypted_t*
pp_dc_cnode2encrypted(pp_dc_cnode_t *x)
{
    if(x==NULL)
	return NULL;
    if(x->tag==PP_DC_TAG_ENCRYPTED)
	return x->un.encrypted;
    else
	return NULL;
}

int
pp_dc_encrypted_parse(BIO *bio,pp_dc_encrypted_t **encrypted,size_t size)
{
    *encrypted=pp_dc_encrypted_new();
    (*encrypted)->size=size;
    return read_data(bio,(char**)&(*encrypted)->data,size);
}

int
pp_dc_encrypted_build(BIO *bio,pp_dc_encrypted_t *encrypted)
{
    if(encrypted->data)
	return write_data(bio,(char*)encrypted->data,encrypted->size);
    else if(encrypted->skey && encrypted->sub) {
	bio=BIO_push(pp_dc_skey2bio(encrypted->skey,1),bio);
	pp_dc_cnode_build(bio,encrypted->sub);
	BIO_flush(bio);
	BIO_free(bio);
	return 1;
    } else return 0;
}

/*pp_dc_encrypted_t*
pp_dc_encrypted_encrypt(pp_dc_cnode_t *node,pp_dc_skey_t *skey)
{
    BIO *membio=BIO_new(BIO_s_mem()),*bio;
    pp_dc_encrypted_t *ret;
    char *data;
    size_t size;

    bio=BIO_push(pp_dc_skey2bio(skey,1),membio);
    pp_dc_cnode_build(bio,node);
    BIO_flush(bio);
    ret=pp_dc_encrypted_new();
    size=BIO_get_mem_data(membio,&data);
    ret->data=malloc(size);
    memcpy(ret->data,data,size);
    ret->size=size;
    BIO_free_all(bio);
    return ret;
}*/

pp_dc_cnode_t*
pp_dc_encrypted_decrypt(pp_dc_encrypted_t *encrypted,pp_dc_skey_t *skey)
{
    BIO *bio=BIO_new_mem_buf(encrypted->data,encrypted->size);

    bio=BIO_push(pp_dc_skey2bio(skey,0),bio);
    if(!pp_dc_cnode_parse(bio,&encrypted->sub)) {
	pp_dc_cnode_free(encrypted->sub);
	encrypted->sub=NULL;
	BIO_free_all(bio);
	return NULL;
    }
    BIO_free_all(bio);

    encrypted->skey=skey;
    free(encrypted->data);
    encrypted->data=NULL;

    return encrypted->sub;
}

pp_dc_encrypted_t*
pp_dc_encrypted_gen(pp_dc_cnode_t *node,pp_dc_skey_t *key)
{
    pp_dc_encrypted_t *ret=pp_dc_encrypted_new();
    ret->sub=node;
    ret->skey=key;
    return ret;
}
