#include "disconf_intern.h"

#include <liberic_config.h>
#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/rfb.h>
#endif /* PP_FEAT_REMOTE_CONSOLE */

#include <pp/cfg.h>
#include <pp/um.h>

#include <ldap.h>

typedef int(*pp_dc_proto_func_t)(pp_dc_paket_t *in,pp_dc_paket_t *out);


static int
dc_proto_ping(pp_dc_paket_t *in UNUSED,pp_dc_paket_t *out)
{
    if(ks_pubkey_pemx) {
	out->msg.msg=HEADER_MALLOC(pp_dc_message_t,sizeof(pp_dc_keyid_t)+1);
	out->msg_size=sizeof(pp_dc_message_t)+sizeof(pp_dc_keyid_t)+1;
	memcpy(out->msg.msg->data,&ks_pubkey_pemx->keyid,sizeof(pp_dc_keyid_t));
	out->msg.msg->data[sizeof(pp_dc_keyid_t)] =
#if defined(PP_FEAT_REMOTE_CONSOLE)
	    (u_int8_t)pp_rfb_get_connection_count();
#else
	    0;
#endif
	out->msg.msg->command=PP_DC_RESPONSE_BOUND;
    } else {
	out->msg.msg=HEADER_MALLOC(pp_dc_message_t,1);
	out->msg_size=sizeof(pp_dc_message_t)+1;
	out->msg.msg->data[0] =
#if defined(PP_FEAT_REMOTE_CONSOLE)
	    (u_int8_t)pp_rfb_get_connection_count();
#else
	    0;
#endif
	out->msg.msg->command=PP_DC_RESPONSE_NOT_BOUND;
    }
    out->cstate=PP_DC_SIGNED;
    return 1;
}

static int
dc_proto_set(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    if((in->cstate&PP_DC_ENCRYPTED)&&
       (in->cstate&PP_DC_SIGNED)) {
	char *ptr, *startk, *startv;	
	pp_cfg_tx_t *tx=pp_cfg_tx_begin(1);
	int failed=0;

	ptr = in->msg.msg->data;
	while(ptr<in->msg.raw+in->msg_size) {
	    startk = ptr;
	    while(*ptr != '=' && *ptr != '\n' && (ptr<in->msg.raw+in->msg_size))
		ptr++;
	    if(ptr==in->msg.raw+in->msg_size) break;
	    if(*ptr != '=') {
		failed=1;
		goto bail;
	    } else if(ptr - startk > MAX_OPT_KEY_LEN) {
		failed=1;
		goto bail;
	    } else {
		*ptr = '\0';
		startv = ++ptr;
		while(*ptr != '\n' && *ptr && (ptr<in->msg.raw+in->msg_size))
		    ptr++;
		if(((ptr>in->msg.raw+in->msg_size) &&
		    *ptr != '\n') || ptr - startv > MAX_OPT_VALUE_LEN) {
		    failed=1;
		    goto bail;
		} else {
		    startv=strndup(startv,ptr-startv);
		    if(strlen(startv)>0)
			pp_cfg_set_at_layer(PP_PROFILE_LOCAL,startv,startk);
		    free(startv);
		    ptr++;
		}
	    }
	}

    bail:
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);

	if(failed) {
	    pp_cfg_tx_rollback(tx);
	    out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	} else {
	    pp_cfg_tx_commit_core(tx,DO_FLUSH,0,0,NULL);
	    out->msg.msg->command=PP_DC_RESPONSE_OK;
	}

	out->cstate=PP_DC_SIGNED;
	
	return 1;
    } else {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}

static int
dc_proto_get(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    if((in->cstate&PP_DC_ENCRYPTED)&&
       (in->cstate&PP_DC_SIGNED)) {
	char *key=(char*)malloc(in->msg_size-sizeof(pp_dc_message_t)+1);
	char* data;
	memcpy(key,in->msg.msg->data,in->msg_size-sizeof(pp_dc_message_t));
	key[in->msg_size-sizeof(pp_dc_message_t)]=0;
	if(pp_cfg_get(&data,key)==PP_ERR) {
	    free(key);
	    goto bail;
	}
	out->msg.msg=HEADER_MALLOC(pp_dc_message_t,strlen(data)+1);
	out->msg_size=sizeof(pp_dc_message_t)+strlen(data)+1;
	out->msg.msg->command=PP_DC_RESPONSE_OK;
	strcpy(out->msg.msg->data,data);
	out->cstate=PP_DC_SIGNED|PP_DC_ENCRYPTED;
	return 1;
    }
 bail:
    out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
    out->msg_size=sizeof(pp_dc_message_t);
    out->msg.msg->command=PP_DC_RESPONSE_FAILED;
    out->cstate=PP_DC_SIGNED;
    return 1;
}

static int
dc_proto_bind(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    if(in->cstate&PP_DC_ENCRYPTED && 
       (in->cstate&PP_DC_SIGNED || !ks_pubkey_pemx)) {
	pp_dc_cnode_t *node;
	if(!pp_dc_cnode_parse_mem(in->msg.msg->data,in->msg_size-sizeof(pp_dc_message_t),&node))
	    return 0;
	pp_dc_keystore_set_pemx(pp_dc_cnode2pubkey(node));
	free(node);
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_OK;
	out->cstate=PP_DC_SIGNED;
	return 1;
    } else {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}

static int
dc_proto_release(pp_dc_paket_t *in,pp_dc_paket_t *out)
{

    if((in->cstate&PP_DC_ENCRYPTED)&&
       (in->cstate&PP_DC_SIGNED)) {
	pp_dc_keystore_set_pemx(NULL);
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_OK;
	out->cstate=PP_DC_SIGNED;
	return 1;
    } else {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}

static int
dc_proto_get_pubkey(pp_dc_paket_t *in UNUSED,pp_dc_paket_t *out)
{
    BIO *membio=BIO_new(BIO_s_mem());
    char *data;
    size_t size;
    pp_dc_cnode_t *node=pp_dc_pubkey2cnode(ks_pubkey);

    pp_dc_cnode_build(membio,node);
    free(node);
    size=BIO_get_mem_data(membio,&data);
    out->msg.msg=HEADER_MALLOC(pp_dc_message_t,size);
    memcpy(out->msg.msg->data,data,size);
    out->msg_size=size+sizeof(pp_dc_message_t);
    out->msg.msg->command=PP_DC_RESPONSE_OK;
    BIO_free(membio);
    return 1;
}

/*
static int
dc_proto_fw_update(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
	return 0;
    if((in->cstate&PP_DC_ENCRYPTED)&&
       (in->cstate&PP_DC_SIGNED)) {

	LDAPURLDesc *desc;
	char *url=strndup(in->msg.msg->data,in->msg_size-sizeof(pp_dc_message_t));
	LDAP *ldap=NULL;
	LDAPMessage *msg;
	uint8_t ret=PP_DC_RESPONSE_FAILED;

	if(ldap_url_parse(url,&desc)) {
	    goto bail;
	}

	if(!(ldap=ldap_init(desc->lud_host,desc->lud_port)))
	    goto bail;

	{
	    int version=LDAP_VERSION3;
	    ldap_set_option(ldap,LDAP_OPT_PROTOCOL_VERSION,(void*) &version);
	}

	if(ldap_search_s(ldap,desc->lud_dn,LDAP_SCOPE_BASE,"(objectClass=ppFirmware)",NULL,0,&msg)!=LDAP_SUCCESS) {
	    goto bail;
	}

	{
	    struct berval **val=ldap_get_values_len(ldap,msg,"ppFirmware");
	    pp_log("fwupdate: %d bytes\n",(int)val[0]->bv_len);
	    //m_AttrMap[a].values.push_back(wxString(temp[0]->bv_val,temp[0]->bv_len));
	    ldap_value_free_len(val);		
	}

	ret=PP_DC_RESPONSE_OK;
	
    bail:
	free(url);
	ldap_unbind(ldap);
	ldap_free_urldesc(desc);
	
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=ret;
	out->cstate=PP_DC_SIGNED;
	return 1;
    } else {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}
*/

#define CCF_USER_SIZE 12
static char ccf_user[CCF_USER_SIZE]="";

static int
dc_proto_ccf_create(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    if(in->cstate&PP_DC_ENCRYPTED && 
       (in->cstate&PP_DC_SIGNED || !ks_pubkey_pemx)) {
	char * passwd=strndupa(in->msg.msg->data,in->msg_size-sizeof(pp_dc_message_t));
	u_int32_t id;
	if(ccf_user[0]!=0)
	    pp_um_user_delete(ccf_user);
	pp_dc_generate_msgid(&id);
	snprintf(ccf_user,CCF_USER_SIZE,"ccf%x",id);
	if(pp_um_user_create(ccf_user,"",PP_UM_AUTH_NO_FLAGS,"Administrator",NULL,0)==PP_ERR)
	    goto bail;
	if(pp_um_user_set_password(ccf_user,passwd,PP_UM_AUTH_NO_FLAGS)==PP_ERR)
	    goto bail;
	out->msg.msg=HEADER_MALLOC(pp_dc_message_t,CCF_USER_SIZE);
	out->msg_size=sizeof(pp_dc_message_t)+CCF_USER_SIZE;
	out->msg.msg->command=PP_DC_RESPONSE_OK;
	memcpy(out->msg.msg->data,ccf_user,CCF_USER_SIZE);
	out->cstate=PP_DC_SIGNED|PP_DC_ENCRYPTED;
	return 1;
    } else {
bail:
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}

static int
dc_proto_ccf_delete(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    if(in->cstate&PP_DC_ENCRYPTED && 
       (in->cstate&PP_DC_SIGNED || !ks_pubkey_pemx)) {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	if(pp_um_user_delete(ccf_user)==PP_ERR)
	    out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	else
	    out->msg.msg->command=PP_DC_RESPONSE_OK;
	ccf_user[0]=0;
	out->cstate=PP_DC_SIGNED;
	return 1;
    } else {
	out->msg.msg=STRUCT_MALLOC(pp_dc_message_t);
	out->msg_size=sizeof(pp_dc_message_t);
	out->msg.msg->command=PP_DC_RESPONSE_FAILED;
	out->cstate=PP_DC_SIGNED;
	return 1;
    }
}

pp_dc_proto_func_t funcs[16]={dc_proto_ping,
			      dc_proto_set,
			      dc_proto_get,
			      dc_proto_bind,
			      dc_proto_release,
			      dc_proto_get_pubkey,
			      NULL,//dc_proto_fw_update,
			      NULL,
			      NULL,
			      NULL,
			      NULL,
			      NULL,
			      NULL,
			      NULL,
			      dc_proto_ccf_create,
			      dc_proto_ccf_delete};

static int
verify_and_decrypt(pp_dc_paket_t *paket)
{
    if((paket->msg_size=pp_dc_decrypt_and_verify(paket->cnode,
						&paket->cstate,
						ks_privkey,
						ks_pubkey_pemx,
						&paket->msg.raw))>0)
	return 1;
    else
	return 0;

}

static int
sign_and_encrypt(pp_dc_paket_t *paket)
{
    return pp_dc_sign_and_encrypt(paket->msg.raw,
				  paket->msg_size,
				  paket->cstate,
				  ks_privkey,
				  ks_pubkey_pemx,
				  &paket->cnode);
}

int 
pp_dc_proto_proc(pp_dc_paket_t *in,pp_dc_paket_t *out)
{
    char *data;
    size_t size;
    BIO *bio;
    int ret=PP_ERR;
    
    assert(in->net.net);

    in->cnode=NULL;
    in->msg.raw=NULL;
    out->cnode=NULL;
    out->msg.raw=NULL;
    out->net.raw=NULL;
    
    // the payload of the paket must be least a plain node + message
    if(in->net_size<sizeof(pp_dc_net_t)+3+sizeof(pp_dc_message_t))
	goto bail;
    
    // try to parse the content
    if(!pp_dc_cnode_parse_mem(in->net.net->data,in->net_size-sizeof(pp_dc_net_t),&in->cnode)) {
	pp_log("%s(): parse error\n", ___F);
	goto bail;
    }

    // decrypt and verify, if possible
    if(!verify_and_decrypt(in)) {
	pp_log("%s(): structur error\n", ___F);
	goto bail;
    }

    // size of content must be at least size of a message-struct
    if(in->msg_size<sizeof(pp_dc_message_t)) 
	goto bail;

    // check wether the command is known
    if(in->msg.msg->command>=16)
	goto bail;

    if(funcs[in->msg.msg->command]==NULL)
	goto bail;

    // execute command
    if(!funcs[in->msg.msg->command](in,out)) {
	goto bail;
    }

    //pp_log("message msgid=%x,cmd=%d\n",in->msg.msg->msg_id,in->msg.msg->command);
    // msg_id of the outgoing paket must be the that of the incoming
    out->msg.msg->msg_id=in->msg.msg->msg_id;

    sign_and_encrypt(out);

    // build the net-struct
    bio=BIO_new(BIO_s_mem());

    pp_dc_cnode_build(bio,out->cnode);

    size=BIO_get_mem_data(bio,&data);

    out->net.net=HEADER_MALLOC(pp_dc_net_t,size);
    memcpy(out->net.net->data,data,size);
    out->net_size=size+sizeof(pp_dc_net_t);

    BIO_free(bio);

    ret=0;

 bail:
    if(in->cnode)
	pp_dc_cnode_free(in->cnode);
    in->cnode=NULL;
    if(out->cnode)
	pp_dc_cnode_free(out->cnode);

    return ret;
}
