#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include <pp/base.h>
#include <pp/cfg.h>
#include <pp/disconf.h>
#include <liberic_pthread.h>

#include "disconf_intern.h"

static int pp_dc_running=0;
static int pp_dc_worker_should_die=0;
static pthread_t pp_dc_thread;
static int pp_dc_socket=-1;

#define MTU 1452

static void *
pp_dc_worker(void *arg UNUSED)
{
    pp_dc_paket_t in;
    pp_dc_paket_t out;
    struct sockaddr_in from;
    socklen_t fromlen=sizeof(from);
    ssize_t size;

    pp_dc_running=1;

    in.net.raw=malloc(MTU);

    while(!pp_dc_worker_should_die) {
	memset(&from,0,sizeof(from));
	if((size=recvfrom(pp_dc_socket,in.net.raw,MTU,0,&from,&fromlen))==-1) {
	    pp_log_err("%s(): recv() failed", ___F);
	    continue;
	}
	in.net_size=size;

	if(in.net_size<sizeof(pp_dc_net_t)) {
	    pp_log("%s(): paket too small\n", ___F);
	    continue;
	}

	// convert form network byte ordering
	in.net.net->magic_num=ntohl(in.net.net->magic_num);

	if(in.net.net->magic_num!=PP_DC_MAGIC_NUM) {
	    //pp_log("%s(): bad magic number\n", ___F);
	    continue;
	}
	
	if((memcmp(in.net.net->dest.ui,pp_eui64.ui,sizeof(pp_eui64))!=0)&&
	   (memcmp(in.net.net->dest.ui,eui64_all.ui,sizeof(pp_eui64))!=0)) {
	    //pp_log("%s(): this is not the destination\n", ___F);
	    continue;
	}

	if(pp_dc_proto_proc(&in,&out)!=PP_SUC)
	    continue;

	out.net.net->version=PP_DC_VERSION;
	out.net.net->magic_num=htonl(PP_DC_MAGIC_NUM);
	out.net.net->src=pp_eui64;
	out.net.net->dest=in.net.net->src;

	if(sendto(pp_dc_socket,out.net.raw,out.net_size,0,&from,fromlen)==-1) {
	    //pp_log_err("%s(): sendto() failed", ___F);
	}

	free(out.net.raw);
    }

    free(in.net.raw);

    pp_dc_running=0;
    pthread_exit(NULL);
}

int
pp_dc_server_init(void)
{
    struct sockaddr_in addr;

    if(!pp_dc_keystore_init())
	goto bail;
#if 0
    printf("Local KeyID: %.2x %.2x %.2x %.2x %.2x %.2x %.2x %.2x\n",
	   ks_pubkey->keyid.ui[0],ks_pubkey->keyid.ui[1],
	   ks_pubkey->keyid.ui[2],ks_pubkey->keyid.ui[3],
	   ks_pubkey->keyid.ui[4],ks_pubkey->keyid.ui[5],
	   ks_pubkey->keyid.ui[6],ks_pubkey->keyid.ui[7]);
#endif
    if(ks_pubkey_pemx) {
#if 0
	printf("PEMX KeyID: %.2x %.2x %.2x %.2x %.2x %.2x %.2x %.2x\n",
	       ks_pubkey_pemx->keyid.ui[0],ks_pubkey_pemx->keyid.ui[1],
	       ks_pubkey_pemx->keyid.ui[2],ks_pubkey_pemx->keyid.ui[3],
	       ks_pubkey_pemx->keyid.ui[4],ks_pubkey_pemx->keyid.ui[5],
	       ks_pubkey_pemx->keyid.ui[6],ks_pubkey_pemx->keyid.ui[7]);
#endif
    }
    if((pp_dc_socket=socket(PF_INET,SOCK_DGRAM,0))==-1) {
	pp_log_err("%s(): socket() failed", ___F);
	goto bail;
    }

    addr.sin_port=htons(456);
    addr.sin_family=AF_INET;
    addr.sin_addr.s_addr=INADDR_ANY;

    if(bind(pp_dc_socket,&addr,sizeof(addr))==-1) {
	pp_log_err("%s(): bind() failed", ___F);
	goto bail;
    }

    if(eric_pthread_create(&pp_dc_thread,0,65536,pp_dc_worker,NULL)!=0) {
	pp_log("%s(): Cannot create dc-thread.\n", ___F);
	return -1;
    }

    pp_log("%s(): disconf started...\n", ___F);

    return PP_SUC;
 bail:
    return PP_ERR;
}

void
pp_dc_cleanup(void)
{
    pp_dc_worker_should_die=1;
    close(pp_dc_socket);
}
