#include "disconf_intern.h"

#include <openssl/evp.h>
#include <openssl/rand.h>

/***************************************************************
 * Secret Key
 ***************************************************************/

pp_dc_skey_t*
pp_dc_skey_new()
{
    pp_dc_skey_t *ret=(pp_dc_skey_t*)malloc(sizeof(pp_dc_skey_t));
    ret->algo=0;
    ret->size=0;
    ret->data=NULL;
    return ret;
}

void
pp_dc_skey_free(pp_dc_skey_t *skey)
{
    free(skey->data);
    free(skey);
}

pp_dc_cnode_t*
pp_dc_skey2cnode(pp_dc_skey_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_SKEY,x);
}

pp_dc_skey_t*
pp_dc_cnode2skey(pp_dc_cnode_t *x)
{
    if(x->tag==PP_DC_TAG_SKEY)
	return x->un.skey;
    else
	return NULL;
}

int
pp_dc_skey_parse(BIO *bio,pp_dc_skey_t **skey,size_t size)
{
    *skey=pp_dc_skey_new();
    (*skey)->size=size-1;
    return read_uint8(bio,&(*skey)->algo)&&
	read_data(bio,(char**)&(*skey)->data,(*skey)->size);
}

int
pp_dc_skey_build(BIO *bio,pp_dc_skey_t *skey)
{
    return write_uint8(bio,skey->algo)&&
	write_data(bio,(char*)skey->data,skey->size);
}

pp_dc_skey_t*
pp_dc_skey_gen()
{
    pp_dc_skey_t *ret;
    ret=pp_dc_skey_new();
    ret->algo=PP_DC_SYM_AES_ECB;
    ret->size=16;
    ret->data=malloc(16);
    RAND_bytes(ret->data,16);
    return ret;
}

BIO*
pp_dc_skey2bio(pp_dc_skey_t *skey,int enc)
{
    BIO *ret=BIO_new(BIO_f_cipher());
    switch(skey->algo){
    case PP_DC_SYM_AES_ECB:
	BIO_set_cipher(ret,EVP_aes_128_ecb(),skey->data,NULL,enc);
	break;
    default:
	BIO_free(ret);
	ret=NULL;
    }
    return ret;
}
